/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.linkcheck.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.linkcheck.validation.LinkValidationItem;
import org.apache.maven.linkcheck.validation.LinkValidationResult;
import org.apache.maven.linkcheck.validation.LinkValidator;
import org.apache.maven.linkcheck.validation.LinkValidatorManager;

public class LinkValidatorCache {
    private LinkValidatorManager lvm;
    private final Map cache = new HashMap();

    public LinkValidatorCache(LinkValidatorManager lvm) {
        this.lvm = lvm;
    }

    public void setCachedResult(Object resourceKey, LinkValidationResult lvr) {
        this.cache.put(resourceKey, lvr);
    }

    public LinkValidationResult getCachedResult(LinkValidationItem lvi) {
        Iterator iter = this.lvm.getValidators().iterator();
        while (iter.hasNext()) {
            LinkValidator lv = (LinkValidator)iter.next();
            Object resourceKey = lv.getResourceKey(lvi);
            if (resourceKey == null) continue;
            return (LinkValidationResult)this.cache.get(resourceKey);
        }
        return null;
    }

    public void load(InputStream is) {
        LinkValidationResult LVR_VALID = new LinkValidationResult(2, true);
        LinkValidationResult LVR_INVALID = new LinkValidationResult(1, true);
        try {
            Properties p = new Properties();
            p.load(is);
            Iterator iter = ((Hashtable)p).keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = p.getProperty(key);
                if (value.equals("VALID")) {
                    this.cache.put(key, LVR_VALID);
                }
                if (!value.equals("INVALID")) continue;
                this.cache.put(key, LVR_INVALID);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(OutputStream os) {
        try {
            Properties p = new Properties();
            Iterator iter = this.cache.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                LinkValidationResult lvr = (LinkValidationResult)this.cache.get(key);
                if (!lvr.isPersistent()) continue;
                if (lvr.getStatus() == 2) {
                    p.setProperty(key, "VALID");
                }
                if (lvr.getStatus() != 1) continue;
                p.setProperty(key, "INVALID");
            }
            p.store(os, "LinkCheck Cache");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

