/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Branch;
import org.apache.maven.project.Build;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Developer;
import org.apache.maven.project.License;
import org.apache.maven.project.MailingList;
import org.apache.maven.project.Project;
import org.apache.maven.project.Resource;
import org.apache.maven.project.SourceModification;
import org.apache.maven.project.Version;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class DefaultProjectMarshaller {
    private static final String NAMESPACE = null;
    private static final String ENCODING = null;
    private static final Boolean STANDALONE = null;
    private XmlSerializer serializer;
    private static String INDENTATION = "  ";
    private static String LS = System.getProperty("line.separator");
    private Log log = LogFactory.getLog((Class)(class$org$apache$maven$DefaultProjectMarshaller == null ? (class$org$apache$maven$DefaultProjectMarshaller = DefaultProjectMarshaller.class$("org.apache.maven.DefaultProjectMarshaller")) : class$org$apache$maven$DefaultProjectMarshaller));
    static /* synthetic */ Class class$org$apache$maven$DefaultProjectMarshaller;

    public DefaultProjectMarshaller() throws Exception {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        this.serializer = factory.newSerializer();
    }

    private void initialize(Writer writer) throws IOException {
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)INDENTATION);
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)LS);
        this.serializer.setOutput(writer);
    }

    public void marshall(Writer pom, Project project) throws Exception {
        this.initialize(pom);
        this.serializer.startTag(NAMESPACE, "project");
        this.marshallString(project.getExtend(), "extend");
        this.marshallString(project.getPomVersion(), "pomVersion");
        this.marshallRequiredString(Project.standardToLegacyId(project.getId()), "id");
        this.marshallRequiredString(project.getName(), "name");
        this.marshallString(project.getGroupId(), "groupId");
        this.marshallString(project.getArtifactId(), "artifactId");
        this.marshallRequiredString(project.getCurrentVersion(), "currentVersion");
        this.marshallOrganization(project);
        this.marshallString(project.getInceptionYear(), "inceptionYear");
        this.marshallString(project.getPackage(), "package");
        this.marshallString(project.getLogo(), "logo");
        this.marshallString(project.getGumpRepositoryId(), "gumpRepositoryId");
        this.marshallString(project.getDescription(), "description");
        this.marshallRequiredString(project.getShortDescription(), "shortDescription");
        this.marshallString(project.getUrl(), "url");
        this.marshallString(project.getIssueTrackingUrl(), "issueTrackingUrl");
        this.marshallString(project.getSiteAddress(), "siteAddress");
        this.marshallString(project.getSiteDirectory(), "siteDirectory");
        this.marshallString(project.getDistributionDirectory(), "distributionDirectory");
        this.marshallRepository(project);
        this.marshallVersions(project);
        this.marshallBranches(project);
        this.marshallMailingLists(project);
        this.marshallDevelopers(project);
        this.marshallContributors(project);
        this.marshallLicenses(project);
        this.marshallDependencies(project);
        this.marshallBuild(project);
        this.marshallReports(project);
        this.serializer.endTag(NAMESPACE, "project");
        this.serializer.endDocument();
    }

    private void marshallOrganization(Project project) throws Exception {
        if (project.getOrganization() != null) {
            this.serializer.startTag(NAMESPACE, "organization");
            this.marshallRequiredString(project.getOrganization().getName(), "name");
            this.marshallString(project.getOrganization().getUrl(), "url");
            this.marshallString(project.getOrganization().getLogo(), "logo");
            this.serializer.endTag(NAMESPACE, "organization");
        }
    }

    private void marshallRepository(Project project) throws Exception {
        if (project.getRepository() != null) {
            this.serializer.startTag(NAMESPACE, "repository");
            this.marshallRequiredString(project.getRepository().getConnection(), "connection");
            this.marshallString(project.getRepository().getDeveloperConnection(), "developerConnection");
            this.marshallString(project.getRepository().getUrl(), "url");
            this.serializer.endTag(NAMESPACE, "repository");
        }
    }

    private void marshallVersions(Project project) throws Exception {
        List versions = project.getVersions();
        if (versions != null) {
            this.serializer.startTag(NAMESPACE, "versions");
            int i = 0;
            while (i < versions.size()) {
                Version version = (Version)versions.get(i);
                if (version != null) {
                    this.serializer.startTag(NAMESPACE, "version");
                    this.marshallString(version.getId(), "id");
                    this.marshallString(version.getName(), "name");
                    this.marshallString(version.getTag(), "tag");
                    this.serializer.endTag(NAMESPACE, "version");
                }
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "versions");
        }
    }

    private void marshallBranches(Project project) throws Exception {
        List branches = project.getBranches();
        if (branches != null) {
            this.serializer.startTag(NAMESPACE, "branches");
            int i = 0;
            while (i < branches.size()) {
                Branch branch = (Branch)branches.get(i);
                if (branch != null) {
                    this.serializer.startTag(NAMESPACE, "branch");
                    this.marshallString(branch.getTag(), "tag");
                    this.serializer.endTag(NAMESPACE, "branch");
                }
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "branches");
        }
    }

    private void marshallMailingLists(Project project) throws Exception {
        List mailingLists = project.getMailingLists();
        if (mailingLists != null) {
            this.serializer.startTag(NAMESPACE, "mailingLists");
            int i = 0;
            while (i < mailingLists.size()) {
                MailingList mailingList = (MailingList)mailingLists.get(i);
                if (mailingList != null) {
                    this.serializer.startTag(NAMESPACE, "mailingList");
                    this.marshallRequiredString(mailingList.getName(), "name");
                    this.marshallRequiredString(mailingList.getSubscribe(), "subscribe");
                    this.marshallRequiredString(mailingList.getUnsubscribe(), "unsubscribe");
                    this.marshallString(mailingList.getArchive(), "archive");
                    this.serializer.endTag(NAMESPACE, "mailingList");
                }
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "mailingLists");
        }
    }

    private void marshallDevelopers(Project project) throws Exception {
        List developers = project.getDevelopers();
        this.serializer.startTag(NAMESPACE, "developers");
        int i = 0;
        while (i < developers.size()) {
            Developer developer = (Developer)developers.get(i);
            if (developer != null) {
                this.serializer.startTag(NAMESPACE, "developer");
                this.marshallRequiredString(developer.getName(), "name");
                this.marshallRequiredString(developer.getId(), "id");
                this.serializer.endTag(NAMESPACE, "developer");
            }
            ++i;
        }
        this.serializer.endTag(NAMESPACE, "developers");
    }

    private void marshallContactDetails(Contributor contributor) throws IOException {
        this.serializer.startTag(NAMESPACE, "contactDetails");
        this.marshallRequiredString(contributor.getEmail(), "email");
        this.marshallString(contributor.getOrganization(), "organization");
        this.marshallRoles(contributor);
        this.marshallString(contributor.getUrl(), "url");
        this.serializer.endTag(NAMESPACE, "contactDetails");
    }

    private void marshallRoles(Contributor contributor) throws IOException {
        SortedSet roles = contributor.getRoles();
        if (roles != null) {
            this.serializer.startTag(NAMESPACE, "roles");
            Iterator iterator = roles.iterator();
            while (iterator.hasNext()) {
                this.marshallString((String)iterator.next(), "role");
            }
            this.serializer.endTag(NAMESPACE, "roles");
        }
    }

    private void marshallContributors(Project project) throws Exception {
        List contributors = project.getContributors();
        if (contributors != null && contributors.size() > 0) {
            this.serializer.startTag(NAMESPACE, "contributors");
            int i = 0;
            while (i < contributors.size()) {
                Contributor contributor = (Contributor)contributors.get(i);
                if (contributor != null) {
                    this.serializer.startTag(NAMESPACE, "contributor");
                    this.marshallRequiredString(contributor.getName(), "name");
                    this.serializer.endTag(NAMESPACE, "contributor");
                }
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "contributors");
        }
    }

    private void marshallLicenses(Project project) throws Exception {
        List licenses = project.getLicenses();
        if (licenses != null && licenses.size() > 0) {
            this.serializer.startTag(NAMESPACE, "licenses");
            int i = 0;
            while (i < licenses.size()) {
                License license = (License)licenses.get(i);
                if (license != null) {
                    this.serializer.startTag(NAMESPACE, "license");
                    this.marshallString(license.getName(), "name");
                    this.marshallString(license.getUrl(), "url");
                    this.marshallString(license.getDistribution(), "distribution");
                    this.serializer.endTag(NAMESPACE, "license");
                }
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "licenses");
        }
    }

    private void marshallDependencies(Project project) throws Exception {
        List dependencies = project.getDependencies();
        if (dependencies != null && dependencies.size() > 0) {
            this.serializer.startTag(NAMESPACE, "dependencies");
            int i = 0;
            while (i < dependencies.size()) {
                Dependency dependency = (Dependency)dependencies.get(i);
                if (dependency != null) {
                    this.serializer.startTag(NAMESPACE, "dependency");
                    this.marshallString(Project.standardToLegacyId(dependency.getId()), "id");
                    this.marshallString(dependency.getGroupId(), "groupId");
                    this.marshallString(dependency.getArtifactId(), "artifactId");
                    this.marshallRequiredString(dependency.getVersion(), "version");
                    this.marshallString(dependency.getJar(), "jar");
                    this.marshallString(dependency.getType(), "type");
                    this.marshallString(dependency.getUrl(), "url");
                    this.serializer.endTag(NAMESPACE, "dependency");
                }
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "dependencies");
        }
    }

    private void marshallBuild(Project project) throws Exception {
        Build build = project.getBuild();
        if (build != null) {
            this.serializer.startTag(NAMESPACE, "build");
            this.marshallString(build.getNagEmailAddress(), "nagEmailAddress");
            this.marshallString(build.getSourceDirectory(), "sourceDirectory");
            this.marshallString(build.getUnitTestSourceDirectory(), "unitTestSourceDirectory");
            this.marshallString(build.getIntegrationUnitTestSourceDirectory(), "integrationUnitTestSourceDirectory");
            this.marshallString(build.getAspectSourceDirectory(), "aspectSourceDirectory");
            if (build.getUnitTest() != null) {
                this.serializer.startTag(NAMESPACE, "unitTest");
                this.marshallIncludes(build.getUnitTest().getIncludes());
                this.marshallExcludes(build.getUnitTest().getExcludes());
                this.marshallResources(build.getUnitTest().getResources());
                this.serializer.endTag(NAMESPACE, "unitTest");
            }
            this.marshallResources(build.getResources());
            this.marshallSourceModifications(build.getSourceModifications());
            this.serializer.endTag(NAMESPACE, "build");
        }
    }

    private void marshallSourceModifications(List sourceModifications) throws Exception {
        if (sourceModifications != null && sourceModifications.size() > 0) {
            this.serializer.startTag(NAMESPACE, "sourceModifications");
            int i = 0;
            while (i < sourceModifications.size()) {
                SourceModification sourceModification = (SourceModification)sourceModifications.get(i);
                if (sourceModification != null) {
                    this.serializer.startTag(NAMESPACE, "sourceModification");
                    this.marshallString(sourceModification.getClassName(), "className");
                    this.marshallExcludes(sourceModification.getExcludes());
                    this.serializer.endTag(NAMESPACE, "sourceModification");
                }
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "sourceModifications");
        }
    }

    private void marshallResources(List resources) throws IOException {
        if (resources != null && resources.size() > 0) {
            this.serializer.startTag(NAMESPACE, "resources");
            int i = 0;
            while (i < resources.size()) {
                Resource resource = (Resource)resources.get(i);
                if (resource != null) {
                    this.serializer.startTag(NAMESPACE, "resource");
                    this.marshallString(resource.getDirectory(), "directory");
                    this.marshallString(resource.getTargetPath(), "targetPath");
                    this.marshallIncludes(resource.getIncludes());
                    this.marshallExcludes(resource.getExcludes());
                    this.serializer.endTag(NAMESPACE, "resource");
                }
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "resources");
        }
    }

    private void marshallExcludes(List excludes) throws IOException {
        if (excludes != null && excludes.size() > 0) {
            this.serializer.startTag(NAMESPACE, "excludes");
            int i = 0;
            while (i < excludes.size()) {
                this.marshallRequiredString((String)excludes.get(i), "exclude");
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "excludes");
        }
    }

    private void marshallIncludes(List includes) throws IOException {
        if (includes != null && includes.size() > 0) {
            this.serializer.startTag(NAMESPACE, "includes");
            int i = 0;
            while (i < includes.size()) {
                this.marshallRequiredString((String)includes.get(i), "include");
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "includes");
        }
    }

    private void marshallReports(Project project) throws Exception {
        List reports = project.getReports();
        if (reports != null && reports.size() > 0) {
            this.serializer.startTag(NAMESPACE, "reports");
            int i = 0;
            while (i < reports.size()) {
                this.marshallString((String)reports.get(i), "report");
                ++i;
            }
            this.serializer.endTag(NAMESPACE, "reports");
        }
    }

    private void marshallProperties(Map properties) throws Exception {
        if (properties != null && properties.size() > 0) {
            this.serializer.startTag(NAMESPACE, "properties");
            Iterator i = properties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)properties.get(key);
                this.marshallString(value, key);
            }
            this.serializer.endTag(NAMESPACE, "properties");
        }
    }

    private void marshallString(String line, String tag) throws IOException {
        if (!this.isNull(line)) {
            this.serializer.startTag(NAMESPACE, tag).text(line).endTag(NAMESPACE, tag);
        }
    }

    private void marshallRequiredString(String line, String tag) throws IOException {
        if (this.isNull(line)) {
            this.log.warn((Object)("WARNING : " + tag + " should not be null"));
        }
        this.marshallString(line, tag);
    }

    private boolean isNull(String property) {
        return property == null || property.trim().equals("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

