/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import org.apache.maven.project.ArtifactType;
import org.apache.maven.project.BaseObject;
import org.apache.maven.util.StringTool;

public class Dependency
extends BaseObject {
    private String version;
    private String url;
    private String jar;
    private String artifactId;
    private String groupId;
    private ArtifactType type;

    public void setId(String id) {
        int i = id.indexOf("+");
        int j = id.indexOf(":");
        if (i > 0) {
            this.setGroupId(id.substring(0, i));
            this.setArtifactId(id.replace('+', '-'));
        } else if (j > 0) {
            this.setGroupId(id.substring(0, j));
            this.setArtifactId(id.substring(j + 1));
        } else {
            this.setGroupId(id);
            this.setArtifactId(id);
        }
    }

    public String getId() {
        if (this.isValid(this.getGroupId()) && this.isValid(this.getArtifactId())) {
            return this.getGroupId() + ":" + this.getArtifactId();
        }
        return this.id;
    }

    public void setGroupId(String groupId) {
        this.groupId = StringTool.trim(groupId);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactDirectory() {
        if (this.isValid(this.getGroupId())) {
            return this.getGroupId();
        }
        return this.getId();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = StringTool.trim(artifactId);
    }

    public String getArtifact() {
        if (this.jar != null) {
            return this.jar;
        }
        return this.getArtifactId() + "-" + this.getVersion() + "." + this.getExtension();
    }

    public void setVersion(String version) {
        this.version = StringTool.trim(version);
    }

    public String getVersion() {
        return this.version;
    }

    public void setJar(String jar) {
        if (StringTool.trim(jar).length() == 0) {
            return;
        }
        this.jar = StringTool.trim(jar);
    }

    public String getJar() {
        return this.jar;
    }

    public void setUrl(String url) {
        this.url = StringTool.trim(url);
    }

    public String getUrl() {
        return this.url;
    }

    public String getType() {
        String result = null;
        if (this.type != null) {
            result = this.type.getType();
        }
        return result;
    }

    public String getExtension() {
        String result = null;
        if (this.type != null) {
            result = this.type.getExtension();
        }
        return result;
    }

    public void setType(String type) {
        this.type = ArtifactType.findType(StringTool.trim(type));
    }

    public String toString() {
        return "Dep[ id:" + this.getId() + " pid:" + this.getId() + " ver:" + this.getVersion() + " ar:" + this.getArtifact() + " jar:" + this.getJar() + " ]";
    }

    public boolean isAddedToClasspath() {
        if (this.type != null) {
            String artifactType = this.type.getType();
            return artifactType.equals("jar") || artifactType.equalsIgnoreCase("ejb");
        }
        return false;
    }

    public boolean isPlugin() {
        if (this.type != null) {
            return this.type.getType().equals("plugin");
        }
        return false;
    }
}

