/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import org.apache.plexus.util.StringUtils;

public class DVSLPathTool {
    public static final String getRelativePath(String basedir, String filename) {
        basedir = DVSLPathTool.uppercaseDrive(basedir);
        filename = DVSLPathTool.uppercaseDrive(filename);
        if (basedir == null || basedir.length() == 0 || filename == null || filename.length() == 0 || !filename.startsWith(basedir)) {
            return "";
        }
        String separator = DVSLPathTool.determineSeparator(filename);
        basedir = StringUtils.chompLast((String)basedir, (String)separator);
        filename = StringUtils.chompLast((String)filename, (String)separator);
        String relativeFilename = filename.substring(basedir.length());
        return DVSLPathTool.determineRelativePath(relativeFilename, separator);
    }

    public static final String getRelativePath(String filename) {
        if ((filename = DVSLPathTool.uppercaseDrive(filename)) == null || filename.length() == 0) {
            return "";
        }
        String separator = DVSLPathTool.determineSeparator(filename);
        if (!(filename = StringUtils.chompLast((String)filename, (String)separator)).startsWith(separator)) {
            filename = separator + filename;
        }
        return DVSLPathTool.determineRelativePath(filename, separator);
    }

    public static final String getDirectoryComponent(String filename) {
        if (filename == null || filename.length() == 0) {
            return "";
        }
        String separator = DVSLPathTool.determineSeparator(filename);
        String directory = StringUtils.chomp((String)filename, (String)separator);
        if (filename.equals(directory)) {
            return ".";
        }
        return directory;
    }

    private static final String determineRelativePath(String filename, String separator) {
        if (filename.length() == 0) {
            return "";
        }
        int slashCount = StringUtils.countMatches((String)filename, (String)separator) - 1;
        if (slashCount <= 0) {
            return ".";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < slashCount) {
            sb.append("../");
            ++i;
        }
        return StringUtils.chop((String)sb.toString());
    }

    private static final String determineSeparator(String filename) {
        int backwardCount;
        int forwardCount = StringUtils.countMatches((String)filename, (String)"/");
        return forwardCount >= (backwardCount = StringUtils.countMatches((String)filename, (String)"\\")) ? "/" : "\\";
    }

    static final String uppercaseDrive(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() >= 2 && path.charAt(1) == ':') {
            path = path.substring(0, 1).toUpperCase() + path.substring(1);
        }
        return path;
    }

    public static final String calculateLink(String link, String relativePath) {
        if (link.startsWith("/site/")) {
            return link.substring(5);
        }
        if (link.startsWith("/absolute/")) {
            return link.substring(10);
        }
        if (link.indexOf(":") >= 0) {
            return link;
        }
        if (relativePath.equals(".")) {
            if (link.startsWith("/")) {
                return link.substring(1);
            }
            return link;
        }
        if (relativePath.endsWith("/") && link.startsWith("/")) {
            return relativePath + "." + link.substring(1);
        }
        if (relativePath.endsWith("/") || link.startsWith("/")) {
            return relativePath + link;
        }
        return relativePath + "/" + link;
    }
}

