/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.release;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.maven.release.AbstractPomTransformer;
import org.apache.maven.util.HttpUtils;
import org.dom4j.Node;

public class SnapshotResolver
extends AbstractPomTransformer {
    public String selectNodesXPathExpression() {
        return "/project/dependencies/dependency[version='SNAPSHOT']";
    }

    public String selectNodeXPath() {
        return "version";
    }

    public String getNodeContent(Node node) throws Exception {
        String artifactId;
        String groupId;
        String timestampVersion = null;
        Node idNode = node.selectSingleNode("id");
        if (idNode != null) {
            artifactId = groupId = idNode.getText();
        } else {
            Node artifactIdNode = node.selectSingleNode("artifactId");
            Node groupIdNode = node.selectSingleNode("groupId");
            groupId = groupIdNode.getText();
            artifactId = artifactIdNode.getText();
        }
        String url = "http://www.ibiblio.org/maven/" + groupId + "/jars/" + artifactId + "-snapshot-version";
        File snapshotVersionFile = new File(this.getProject().getParentFile(), artifactId + "-snapshot-version");
        try {
            HttpUtils.getFile((String)url, (File)snapshotVersionFile, (boolean)true, (boolean)false, (String)((String)this.getVariables().get("maven.proxy.host")), (String)((String)this.getVariables().get("maven.proxy.port")), (String)((String)this.getVariables().get("maven.proxy.username")), (String)((String)this.getVariables().get("maven.proxy.password")));
        }
        catch (Exception e) {
            System.out.println("Can't retrieve snapshot version file: " + e.getLocalizedMessage());
        }
        timestampVersion = snapshotVersionFile.exists() ? FileUtils.fileRead((String)snapshotVersionFile.getPath()) : "SNAPSHOT";
        return timestampVersion;
    }

    public void transformNode(Node node) throws Exception {
        Node version = node.selectSingleNode(this.selectNodeXPath());
        version.setText(this.getNodeContent(node));
    }

    public Node getTransformedNode(Node node) throws Exception {
        Node transformedNode = (Node)node.clone();
        Node version = transformedNode.selectSingleNode(this.selectNodeXPath());
        version.setText(this.getNodeContent(transformedNode));
        return transformedNode;
    }
}

