/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.deploy.deployers;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.deploy.deployers.AbstractDeployer;
import org.apache.maven.deploy.exceptions.AuthenticationException;

public abstract class GenericSshDeployer
extends AbstractDeployer {
    private RepositoryInfo repoInfo;
    public static final int DEFAULT_SSH_PORT = 22;
    public static final int SOCKS5_PROXY_PORT = 1080;
    private Session session = null;

    public Session getSession() {
        return this.session;
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repoInfo;
    }

    public void release() {
        this.session.disconnect();
    }

    public void init(RepositoryInfo repoInfo) throws AuthenticationException {
        try {
            String proxyHost;
            this.repoInfo = repoInfo;
            JSch jsch = new JSch();
            int port = repoInfo.getPort();
            if (port == -1) {
                port = 22;
            }
            System.out.println("host: '" + repoInfo.getHost() + "'");
            String host = repoInfo.getHost();
            this.session = jsch.getSession(repoInfo.getUserName(), host, port);
            if (repoInfo.getPrivateKey() != null) {
                File privateKey = new File(repoInfo.getPrivateKey());
                if (privateKey.exists()) {
                    if (repoInfo.getPassphrase() == null) {
                        String msg = "Private key provided without passphrase for repo: " + repoInfo.getRepositoryAlias();
                        throw new AuthenticationException(msg);
                    }
                    System.out.println("Using private key: " + privateKey);
                    jsch.addIdentity(privateKey.getAbsolutePath(), repoInfo.getPassphrase());
                } else {
                    String msg = "Private key: " + privateKey + " not found ";
                    throw new AuthenticationException(msg);
                }
            }
            if ((proxyHost = repoInfo.getProxyHost()) != null) {
                ProxySOCKS5 proxy = null;
                int proxyPort = repoInfo.getProxyPort();
                if (proxyPort == 1080) {
                    proxy = new ProxySOCKS5(proxyHost);
                    proxy.setUserPasswd(repoInfo.getProxyUserName(), repoInfo.getProxyPassword());
                } else {
                    proxy = new ProxyHTTP(proxyHost, proxyPort);
                    ((ProxyHTTP)proxy).setUserPasswd(repoInfo.getProxyUserName(), repoInfo.getProxyPassword());
                }
                proxy.connect(this.session, host, port);
            }
            MavenUserInfo ui = new MavenUserInfo(repoInfo);
            this.session.setUserInfo((UserInfo)ui);
            this.session.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), e);
        }
    }

    public class MavenUserInfo
    implements UserInfo {
        RepositoryInfo repoInfo;

        MavenUserInfo(RepositoryInfo repoInfo) {
            this.repoInfo = repoInfo;
        }

        public String getPassphrase() {
            return this.repoInfo.getPassphrase();
        }

        public String getPassword() {
            return this.repoInfo.getPassword();
        }

        public boolean promptPassphrase(String arg0) {
            return true;
        }

        public boolean promptPassword(String arg0) {
            return true;
        }

        public boolean promptYesNo(String arg0) {
            return true;
        }

        public void showMessage(String message) {
            System.out.println(message);
        }
    }
}

