/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.struts;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.j2ee.WarClassLoader;
import org.apache.maven.j2ee.WarFile;
import org.apache.maven.j2ee.WarValidator;
import org.apache.maven.struts.Action;
import org.apache.maven.struts.FormBean;
import org.apache.maven.struts.Forward;
import org.apache.maven.struts.Struts10WarFile;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class Struts10WarValidator
extends WarValidator {
    private String config = "WEB-INF/struts-config.xml";

    public void setConfig(String config) {
        this.config = config;
    }

    public String getConfig() {
        return this.config;
    }

    protected void validateWarContents() {
        try {
            super.validateWarContents();
            Struts10WarFile strutsWar = new Struts10WarFile(this.getWarFileName());
            strutsWar.setConfig(this.getConfig());
            this.validateStrutsConfig(strutsWar);
            this.validateFormBeans(strutsWar);
            this.validateActions(strutsWar);
            this.validateForwards(strutsWar);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.error("Error reading struts war file");
        }
    }

    private boolean isBoolean(String value) {
        return value == null || value.equals("true") || value.equals("false");
    }

    private void validateAction(Action action, Map formBeans, ClassLoader loader) {
        this.info("validating action for path: '" + action.getPath() + "'");
        if (action.getClassName() != null) {
            this.validateClass(action.getClassName(), loader);
        }
        if (action.getName() != null && formBeans.get(action.getName()) == null) {
            this.error("action refers to a non-existent form bean: '" + action.getName() + "'");
        }
        if (!action.getPath().startsWith("/")) {
            this.error("action path (" + action.getPath() + ") doesn't start " + "with a '/'");
        }
        if (action.getScope() != null && !action.getScope().equals("request") && !action.getScope().equals("session")) {
            this.error("scope (" + action.getScope() + ") is not 'request' or " + "'session'");
        }
        if (action.getType() != null) {
            this.validateClass(action.getType(), loader);
        }
        if (!this.isBoolean(action.getUnknown())) {
            this.error("unknown attribute is not 'true' or 'false'");
        }
        if (!this.isBoolean(action.getValidate())) {
            this.error("validate attribute is not 'true' or 'false'");
        }
    }

    private void validateActions(Struts10WarFile war) throws IOException {
        this.info("validating Struts Actions");
        List actions = war.getActions();
        Action action = null;
        WarClassLoader loader = new WarClassLoader((WarFile)war, ((Object)((Object)this)).getClass().getClassLoader());
        List formBeans = war.getFormBeans();
        HashMap<String, FormBean> formBeansByName = new HashMap<String, FormBean>();
        FormBean formBean = null;
        int index = 0;
        while (index < formBeans.size()) {
            formBean = (FormBean)formBeans.get(index);
            formBeansByName.put(formBean.getName(), formBean);
            ++index;
        }
        int index2 = 0;
        while (index2 < actions.size()) {
            action = (Action)actions.get(index2);
            if (CollectionUtils.cardinality((Object)action, (Collection)actions) > 1) {
                this.error("action is a duplicate (by path)");
            }
            this.validateAction(action, formBeansByName, (ClassLoader)loader);
            ++index2;
        }
    }

    private void validateFormBeans(Struts10WarFile strutsWar) throws IOException {
        this.info("validating Struts Form Beans");
        List formBeans = strutsWar.getFormBeans();
        FormBean bean = null;
        WarClassLoader loader = new WarClassLoader((WarFile)strutsWar, ((Object)((Object)this)).getClass().getClassLoader());
        if (strutsWar.getFormBeansType() != null) {
            this.validateClass(strutsWar.getFormBeansType(), (ClassLoader)loader);
        }
        int index = 0;
        while (index < formBeans.size()) {
            bean = (FormBean)formBeans.get(index);
            if (CollectionUtils.cardinality((Object)bean, (Collection)formBeans) > 1) {
                this.error("form bean is a duplicate (by name)");
            }
            this.info("validating form bean: '" + bean.getName() + "', class: '" + bean.getType() + "'");
            this.validateClass(bean.getType(), (ClassLoader)loader);
            if (bean.getClassName() != null) {
                this.validateClass(bean.getClassName(), (ClassLoader)loader);
            }
            ++index;
        }
    }

    private void validateForward(Struts10WarFile war, Forward forward, ClassLoader loader) throws IOException {
        String path;
        int queryStringStart;
        if (forward.getClassName() != null) {
            this.validateClass(forward.getClassName(), loader);
        }
        if (StringUtils.isEmpty((String)forward.getName())) {
            this.error("name attribute is required");
        }
        if ((queryStringStart = (path = forward.getPath()).indexOf("?")) != -1) {
            path = path.substring(0, queryStringStart);
        }
        if (!war.hasFile(path)) {
            try {
                String pattern = war.getActionServletPattern();
                pattern = StringUtils.replace((String)pattern, (String)".", (String)"\\.");
                pattern = StringUtils.replace((String)pattern, (String)"*", (String)"(.*)");
                RE regexp = new RE(pattern);
                if (regexp.match(path)) {
                    String actionPath = regexp.getParen(1);
                    Action dummyAction = new Action();
                    dummyAction.setPath(actionPath);
                    if (!war.getActions().contains(dummyAction)) {
                        this.error("action path for forward (" + actionPath + ")" + " not found");
                    }
                } else {
                    this.error("No action or web resource found for '" + path + "'");
                }
            }
            catch (RESyntaxException e) {
                throw new IllegalStateException("bad regular expression created from action servlet url-pattern in web.xml " + e.getMessage());
            }
        }
        if (!this.isBoolean(forward.getRedirect())) {
            this.error("redirect attribute is not 'true' or 'false'");
        }
    }

    private void validateForwards(Struts10WarFile war) throws IOException {
        this.info("validating global forwards");
        WarClassLoader loader = new WarClassLoader((WarFile)war, ((Object)((Object)this)).getClass().getClassLoader());
        if (war.getGlobalForwardsType() != null) {
            this.validateClass(war.getGlobalForwardsType(), (ClassLoader)loader);
        }
        List forwards = war.getForwards();
        Forward forward = null;
        int index = 0;
        while (index < forwards.size()) {
            forward = (Forward)forwards.get(index);
            this.info("validating forward '" + forward.getName() + "', path: '" + forward.getPath() + "'");
            if (CollectionUtils.cardinality((Object)forward, (Collection)forwards) > 1) {
                this.error("forward is a duplicate (by name)");
            }
            this.validateForward(war, forward, (ClassLoader)loader);
            ++index;
        }
    }

    private void validateStrutsConfig(Struts10WarFile strutsWar) {
        this.info("validating Struts Configuration");
        if (strutsWar.getStrutsConfigEntry() == null) {
            this.error("Struts Configuration: '" + strutsWar.getConfig() + "' not found in the war file");
        }
    }
}

