/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.ContentNotice;
import org.apache.maven.project.Project;

public class ContentValidator {
    private List notices;
    private Project project;

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    protected void addNotice(ContentNotice notice) {
        this.notices.add(notice);
    }

    protected void addNotice(String level, String section, String message) {
        this.addNotice(new ContentNotice(level, section, message));
    }

    public List execute() {
        this.notices = new ArrayList();
        this.validateProject();
        return this.notices;
    }

    protected void validateProject() {
        if (this.project.getLogo() == null || this.project.getLogo().trim().length() == 0) {
            this.addNotice("INFO", "/project/logo", "Element is null or empty.  No logo will be displayed.");
        }
        this.validateLicenses();
    }

    protected void validateLicenses() {
        if (this.project.getLicenses().size() == 0) {
            this.addNotice("WARNING", "/project/licenses", "No licenses defined. Your project has a license and it should be entered into the licenses section.");
        }
    }

    protected void validateDevelopers() {
    }
}

