/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.jelly.util.CommandLineParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class Jelly {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$Jelly == null ? (class$org$apache$commons$jelly$Jelly = Jelly.class$("org.apache.commons.jelly.Jelly")) : class$org$apache$commons$jelly$Jelly));
    private JellyContext context;
    private URL url;
    private URL rootContext;
    private boolean loadedProperties = false;
    private String defaultNamespaceURI = null;
    private boolean validateXML = false;
    static /* synthetic */ Class class$org$apache$commons$jelly$Jelly;

    public static void main(String[] args) throws Exception {
        try {
            if (args.length <= 0) {
                System.out.println("Usage: jelly [scriptFile] [-script scriptFile -o outputFile -Dsysprop=syspropval]");
                return;
            }
            CommandLineParser.getInstance().invokeCommandLineJelly(args);
        }
        catch (JellyException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                cause.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public Script compileScript() throws JellyException {
        if (!this.loadedProperties) {
            this.loadedProperties = true;
            this.loadJellyProperties();
        }
        XMLParser parser = new XMLParser();
        try {
            parser.setContext(this.getJellyContext());
        }
        catch (MalformedURLException e) {
            throw new JellyException(e.toString());
        }
        Script script = null;
        try {
            parser.setDefaultNamespaceURI(this.defaultNamespaceURI);
            parser.setValidating(this.validateXML);
            script = parser.parse(this.getUrl());
            script = script.compile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compiled script: " + this.getUrl()));
            }
        }
        catch (IOException e) {
            throw new JellyException("could not parse Jelly script", e);
        }
        catch (SAXException e) {
            throw new JellyException("could not parse Jelly script", e);
        }
        return script;
    }

    public void setScript(String script) throws MalformedURLException {
        this.setUrl(this.resolveURL(script));
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getRootContext() throws MalformedURLException {
        if (this.rootContext == null) {
            this.rootContext = new File(System.getProperty("user.dir")).toURL();
        }
        return this.rootContext;
    }

    public void setRootContext(URL rootContext) {
        this.rootContext = rootContext;
    }

    public JellyContext getJellyContext() throws MalformedURLException {
        if (this.context == null) {
            String text = this.getUrl().toString();
            int idx = text.lastIndexOf(47);
            text = text.substring(0, idx + 1);
            this.context = new JellyContext(this.getRootContext(), new URL(text));
        }
        return this.context;
    }

    public void setDefaultNamespaceURI(String namespace) {
        this.defaultNamespaceURI = namespace;
    }

    public void setValidateXML(boolean validate) {
        this.validateXML = validate;
    }

    protected URL resolveURL(String name) throws MalformedURLException {
        File file = new File(name);
        if (file.exists()) {
            return file.toURL();
        }
        return new URL(name);
    }

    protected void loadJellyProperties() {
        InputStream is = null;
        String userDir = System.getProperty("user.home");
        File f = new File(userDir + File.separator + "jelly.properties");
        try {
            if (f.exists()) {
                is = new FileInputStream(f);
                this.loadProperties(is);
            }
        }
        catch (Exception e) {
            log.error((Object)("Caught exception while loading: " + f.getName() + ". Reason: " + e), (Throwable)e);
        }
        f = new File("jelly.properties");
        try {
            if (f.exists()) {
                is = new FileInputStream(f);
                this.loadProperties(is);
            }
        }
        catch (Exception e) {
            log.error((Object)("Caught exception while loading: " + f.getName() + ". Reason: " + e), (Throwable)e);
        }
        is = this.getClass().getClassLoader().getResourceAsStream("jelly.properties");
        if (is != null) {
            try {
                this.loadProperties(is);
            }
            catch (Exception e) {
                log.error((Object)("Caught exception while loading jelly.properties from the classpath. Reason: " + e), (Throwable)e);
            }
        }
    }

    protected void loadProperties(InputStream is) throws IOException {
        JellyContext context = this.getJellyContext();
        Properties props = new Properties();
        props.load(is);
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = props.getProperty(key);
            context.setVariable(key, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

