/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.CompositeTextScriptBlock;
import org.apache.commons.jelly.impl.ScriptBlock;
import org.apache.commons.jelly.impl.TextScript;

public abstract class TagSupport
implements Tag {
    protected Tag parent;
    protected Script body;
    protected Boolean shouldTrim;
    protected boolean hasTrimmed;
    protected JellyContext context;

    public static Tag findAncestorWithClass(Tag from, Class tagClass) {
        while (from != null) {
            if (tagClass.isInstance(from)) {
                return from;
            }
            from = from.getParent();
        }
        return null;
    }

    public static Tag findAncestorWithClass(Tag from, Collection tagClasses) {
        while (from != null) {
            Iterator iter = tagClasses.iterator();
            while (iter.hasNext()) {
                Class klass = (Class)iter.next();
                if (!klass.isInstance(from)) continue;
                return from;
            }
            from = from.getParent();
        }
        return null;
    }

    public static Tag findAncestorWithClass(Tag from, Class[] tagClasses) {
        return TagSupport.findAncestorWithClass(from, Arrays.asList(tagClasses));
    }

    public TagSupport() {
    }

    public TagSupport(boolean shouldTrim) {
        this.setTrim(shouldTrim);
    }

    public void setTrim(boolean shouldTrim) {
        this.shouldTrim = shouldTrim ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isTrim() {
        if (this.shouldTrim == null) {
            TagSupport parentSupport;
            Tag parent = this.getParent();
            if (parent == null) {
                return true;
            }
            this.shouldTrim = parent instanceof TagSupport ? ((parentSupport = (TagSupport)parent).isTrim() ? Boolean.TRUE : Boolean.FALSE) : Boolean.TRUE;
        }
        return this.shouldTrim;
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setParent(Tag parent) {
        this.parent = parent;
    }

    public Script getBody() {
        if (!this.hasTrimmed) {
            this.hasTrimmed = true;
            if (this.isTrim()) {
                this.trimBody();
            }
        }
        return this.body;
    }

    public void setBody(Script body) {
        this.body = body;
        this.hasTrimmed = false;
    }

    public JellyContext getContext() {
        return this.context;
    }

    public void setContext(JellyContext context) throws JellyTagException {
        this.context = context;
    }

    public void invokeBody(XMLOutput output) throws JellyTagException {
        this.getBody().run(this.context, output);
    }

    protected Tag findAncestorWithClass(Class parentClass) {
        return TagSupport.findAncestorWithClass(this.getParent(), parentClass);
    }

    protected Tag findAncestorWithClass(Class[] parentClasses) {
        return TagSupport.findAncestorWithClass(this.getParent(), parentClasses);
    }

    protected Tag findAncestorWithClass(Collection parentClasses) {
        return TagSupport.findAncestorWithClass(this.getParent(), parentClasses);
    }

    protected String getBodyText() throws JellyTagException {
        StringWriter writer = new StringWriter();
        this.invokeBody(XMLOutput.createXMLOutput(writer));
        return writer.toString();
    }

    protected String getBodyText(boolean shouldEscape) throws JellyTagException {
        StringWriter writer = new StringWriter();
        try {
            this.invokeBody(XMLOutput.createXMLOutput(writer, shouldEscape));
        }
        catch (UnsupportedEncodingException e) {
            throw new JellyTagException(e.toString());
        }
        return writer.toString();
    }

    protected void trimBody() {
        if (this.body instanceof CompositeTextScriptBlock) {
            CompositeTextScriptBlock block = (CompositeTextScriptBlock)this.body;
            List list = block.getScriptList();
            int size = list.size();
            if (size > 0) {
                TextScript textScript;
                Script script = (Script)list.get(0);
                if (script instanceof TextScript) {
                    textScript = (TextScript)script;
                    textScript.trimStartWhitespace();
                }
                if (size > 1 && (script = (Script)list.get(size - 1)) instanceof TextScript) {
                    textScript = (TextScript)script;
                    textScript.trimEndWhitespace();
                }
            }
        } else if (this.body instanceof ScriptBlock) {
            ScriptBlock block = (ScriptBlock)this.body;
            List list = block.getScriptList();
            for (int i = list.size() - 1; i >= 0; --i) {
                Script script = (Script)list.get(i);
                if (!(script instanceof TextScript)) continue;
                TextScript textScript = (TextScript)script;
                String text = textScript.getText();
                if ((text = text.trim()).length() == 0) {
                    list.remove(i);
                    continue;
                }
                textScript.setText(text);
            }
        } else if (this.body instanceof TextScript) {
            TextScript textScript = (TextScript)this.body;
            textScript.trimWhitespace();
        }
    }

    public abstract /* synthetic */ void doTag(XMLOutput var1) throws MissingAttributeException, JellyTagException;
}

