/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class Embedded {
    Jelly m_jellyEngine = new Jelly();
    private JellyContext m_context = new JellyContext();
    private Script m_script;
    private InputStream m_inputStream;
    private OutputStream m_outputStream;
    private XMLOutput m_output = XMLOutput.createXMLOutput(new OutputStreamWriter(System.out));
    Exception m_scriptCompilationException;
    boolean m_scriptCompiled = false;
    private String m_errorMsg;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$impl$Embedded == null ? (class$org$apache$commons$jelly$impl$Embedded = Embedded.class$("org.apache.commons.jelly.impl.Embedded")) : class$org$apache$commons$jelly$impl$Embedded));
    static /* synthetic */ Class class$org$apache$commons$jelly$impl$Embedded;

    public void setContext(JellyContext context) {
        this.m_context = context;
    }

    public JellyContext getContext() {
        return this.m_context;
    }

    public void setVariable(String name, Object value) {
        this.m_context.setVariable(name, value);
    }

    public void setScript(String scriptAsString) {
        try {
            URL url = this.resolveURL(scriptAsString);
            this.m_inputStream = url.openStream();
        }
        catch (MalformedURLException e) {
            this.m_inputStream = new ByteArrayInputStream(scriptAsString.getBytes());
        }
        catch (IOException e) {
            this.m_inputStream = null;
        }
        this.compileScriptAndKeep();
    }

    private URL resolveURL(String name) throws MalformedURLException {
        File file = new File(name);
        if (file.exists()) {
            return file.toURL();
        }
        return new URL(name);
    }

    public void setScript(InputStream scriptAsInputStream) {
        this.m_inputStream = scriptAsInputStream;
        this.compileScriptAndKeep();
    }

    private void compileScriptAndKeep() {
        XMLParser parser = new XMLParser();
        parser.setContext(this.m_context);
        try {
            this.m_script = parser.parse(this.m_inputStream);
            this.m_script = this.m_script.compile();
            this.m_scriptCompiled = true;
        }
        catch (IOException e) {
            this.m_scriptCompilationException = e;
            this.m_scriptCompiled = false;
        }
        catch (SAXException e) {
            this.m_scriptCompilationException = e;
            this.m_scriptCompiled = false;
        }
        catch (Exception e) {
            this.m_scriptCompilationException = e;
            this.m_scriptCompiled = false;
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.m_outputStream = outputStream;
        this.m_output = XMLOutput.createXMLOutput(new OutputStreamWriter(this.m_outputStream));
    }

    public void registerTagLibrary(String namespaceURI, String className) {
        if (this.m_context != null) {
            this.m_context.registerTagLibrary(namespaceURI, className);
        }
    }

    public void registerTagLibrary(String namespaceURI, TagLibrary taglib) {
        if (this.m_context != null) {
            this.m_context.registerTagLibrary(namespaceURI, taglib);
        }
    }

    public String getErrorMsg() {
        return this.m_errorMsg;
    }

    private void setErrorMsg(String errorMsg) {
        this.m_errorMsg = errorMsg;
    }

    public boolean execute() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting Execution");
        }
        if (!this.m_scriptCompiled) {
            if (log.isErrorEnabled()) {
                log.error((Object)this.m_scriptCompilationException.getMessage());
            }
            this.setErrorMsg(this.m_scriptCompilationException.getMessage());
            return false;
        }
        if (this.m_inputStream == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"[Error] Input script-resource NOT accessible");
            }
            this.setErrorMsg("[Error] Input script-resource NOT accessible");
            return false;
        }
        try {
            this.m_script.run(this.m_context, this.m_output);
            this.m_outputStream.close();
            this.m_output.flush();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e.getMessage());
            }
            this.setErrorMsg(e.getMessage());
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Done Executing");
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

