/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.j2ee;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.j2ee.J2EEEntityResolver;
import org.apache.maven.j2ee.war.FormLoginConfig;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public class WarFile
extends JarFile {
    public static final String WEB_XML = "WEB-INF/web.xml";
    public static final String LIB = "WEB-INF/lib/";

    public WarFile(String name) throws IOException {
        super(name);
    }

    public WarFile(String name, boolean verify) throws IOException {
        super(name, verify);
    }

    public WarFile(File warFile) throws IOException {
        super(warFile);
    }

    public WarFile(File warFile, boolean verify) throws IOException {
        super(warFile, verify);
    }

    public WarFile(File warFile, boolean verify, int mode) throws IOException {
        super(warFile, verify, mode);
    }

    public JarEntry getWebXmlEntry() {
        return this.getJarEntry(WEB_XML);
    }

    public Map getServlets() throws IOException {
        HashMap<String, String> servlets = new HashMap<String, String>();
        if (this.getWebXmlEntry() != null) {
            Document webXml = this.getWebXml();
            List servletNodes = webXml.selectNodes("//servlet");
            Node node = null;
            Iterator nodes = servletNodes.iterator();
            while (nodes.hasNext()) {
                node = (Node)nodes.next();
                String servletName = node.selectSingleNode("./servlet-name").getText();
                Node servletClass = node.selectSingleNode("./servlet-class");
                if (servletClass == null) continue;
                servlets.put(servletName, servletClass.getText());
            }
        }
        return servlets;
    }

    public Map getJSPs() throws IOException {
        HashMap<String, String> jsps = new HashMap<String, String>();
        if (this.getWebXmlEntry() != null) {
            Document webXml = this.getWebXml();
            List servletNodes = webXml.selectNodes("//servlet");
            Node node = null;
            Iterator nodes = servletNodes.iterator();
            while (nodes.hasNext()) {
                node = (Node)nodes.next();
                String servletName = node.selectSingleNode("./servlet-name").getText();
                Node jspFile = node.selectSingleNode("./jsp-file");
                if (jspFile == null) continue;
                jsps.put(servletName, jspFile.getText());
            }
        }
        return jsps;
    }

    public Map getTaglibs() throws IOException {
        HashMap<String, String> taglibs = new HashMap<String, String>();
        if (this.getWebXmlEntry() != null) {
            Document webXml = this.getWebXml();
            List taglibNodes = webXml.selectNodes("//taglib");
            Node node = null;
            Iterator nodes = taglibNodes.iterator();
            while (nodes.hasNext()) {
                node = (Node)nodes.next();
                String taglibUri = node.selectSingleNode("./taglib-uri").getText();
                String taglibLocation = node.selectSingleNode("./taglib-location").getText();
                taglibs.put(taglibUri, taglibLocation);
            }
        }
        return taglibs;
    }

    protected Document getWebXml() throws IOException {
        if (this.getWebXmlEntry() == null) {
            throw new IOException("Attempted to get non-existent web.xml");
        }
        try {
            SAXReader xmlReader = new SAXReader(false);
            xmlReader.setEntityResolver((EntityResolver)new J2EEEntityResolver());
            InputStream webXmlStream = this.getInputStream(this.getWebXmlEntry());
            Document webXml = xmlReader.read(webXmlStream);
            return webXml;
        }
        catch (DocumentException de) {
            de.printStackTrace();
            throw new IOException(de.getMessage());
        }
    }

    public Set getLibEntries() {
        HashSet<JarEntry> libs = new HashSet<JarEntry>();
        Enumeration<JarEntry> entries = this.entries();
        JarEntry entry = null;
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (!entry.getName().startsWith(LIB) || !entry.getName().toLowerCase().endsWith(".jar")) continue;
            libs.add(entry);
        }
        return libs;
    }

    public File extract(JarEntry entry) throws IOException {
        File tempFile = File.createTempFile("maven", null);
        BufferedInputStream inStream = new BufferedInputStream(this.getInputStream(entry));
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(tempFile));
        int status = -1;
        while ((status = inStream.read()) != -1) {
            outStream.write(status);
        }
        outStream.close();
        inStream.close();
        return tempFile;
    }

    public boolean hasFile(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName parameter can't be null");
        }
        String entryName = null;
        if (fileName.startsWith("/")) {
            entryName = fileName.substring(1);
            return this.getJarEntry(entryName) != null;
        }
        return false;
    }

    public Map getErrorPages() throws IOException {
        HashMap<String, String> errorPages = new HashMap<String, String>();
        if (this.getWebXmlEntry() != null) {
            Document webXml = this.getWebXml();
            List errorNodes = webXml.selectNodes("//error-page");
            Node node = null;
            Iterator nodes = errorNodes.iterator();
            while (nodes.hasNext()) {
                node = (Node)nodes.next();
                Node errorCodeNode = node.selectSingleNode("./error-code");
                Node exceptionTypeNode = node.selectSingleNode("./exception-type");
                String location = node.selectSingleNode("./location").getText();
                String key = null;
                key = errorCodeNode == null ? exceptionTypeNode.getText() : errorCodeNode.getText();
                errorPages.put(key, location);
            }
        }
        return errorPages;
    }

    public FormLoginConfig getFormLoginConfig() throws IOException {
        Document webXml;
        Node formLoginConfigNode;
        FormLoginConfig config = null;
        if (this.getWebXmlEntry() != null && (formLoginConfigNode = (webXml = this.getWebXml()).selectSingleNode("//form-login-config")) != null) {
            String login = formLoginConfigNode.selectSingleNode("./form-login-page").getText();
            String error = formLoginConfigNode.selectSingleNode("./form-error-page").getText();
            config = new FormLoginConfig(login, error);
        }
        return config;
    }

    public Map getServletMappings() throws IOException {
        HashMap<String, String> mappings = new HashMap<String, String>();
        if (this.getWebXmlEntry() != null) {
            Document webXml = this.getWebXml();
            List nodes = webXml.selectNodes("/web-app/servlet-mapping");
            Node node = null;
            int nodeIndex = 0;
            while (nodeIndex < nodes.size()) {
                node = (Node)nodes.get(nodeIndex);
                String servletName = node.valueOf("./servlet-name");
                String urlPattern = node.valueOf("./url-pattern");
                mappings.put(servletName, urlPattern);
                ++nodeIndex;
            }
        }
        return mappings;
    }
}

