/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.beans.IntrospectionException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.betwixt.io.AbstractBeanWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class BeanWriter
extends AbstractBeanWriter {
    private static final String LESS_THAN_ENTITY = "&lt;";
    private static final String GREATER_THAN_ENTITY = "&gt;";
    private static final String AMPERSAND_ENTITY = "&amp;";
    private static final String APOSTROPHE_ENTITY = "&apos;";
    private static final String QUOTE_ENTITY = "&quot;";
    private Writer writer;
    private static final String EOL = "\n";
    private String endOfLine = "\n";
    private String indent;
    private boolean autoFlush;
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$BeanWriter == null ? (class$org$apache$commons$betwixt$io$BeanWriter = BeanWriter.class$("org.apache.commons.betwixt.io.BeanWriter")) : class$org$apache$commons$betwixt$io$BeanWriter));
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$BeanWriter;

    public BeanWriter() {
        this(System.out);
    }

    public BeanWriter(OutputStream out) {
        this.writer = new BufferedWriter(new OutputStreamWriter(out));
        this.autoFlush = true;
    }

    public BeanWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeXmlDeclaration(String xmlDeclaration) throws IOException {
        this.writer.write(xmlDeclaration);
        this.writePrintln();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(Object bean) throws IOException, SAXException, IntrospectionException {
        super.write(bean);
        if (this.autoFlush) {
            this.writer.flush();
        }
    }

    public void enablePrettyPrint() {
        this.endOfLine = EOL;
        this.indent = "  ";
    }

    public String getEndOfLine() {
        return this.endOfLine;
    }

    public void setEndOfLine(String endOfLine) {
        this.endOfLine = endOfLine;
        int i = 0;
        while (i < endOfLine.length()) {
            if (!Character.isWhitespace(endOfLine.charAt(i))) {
                this.log.warn((Object)"Invalid EndOfLine character(s)");
                break;
            }
            ++i;
        }
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected void expressElementStart(String qualifiedName) throws IOException {
        if (qualifiedName == null) {
            this.log.fatal((Object)"[expressElementStart]Qualified name is null.");
            throw new RuntimeException("Qualified name is null.");
        }
        this.writePrintln();
        this.writeIndent();
        this.writer.write(60);
        this.writer.write(qualifiedName);
    }

    protected void expressTagClose() throws IOException {
        this.writer.write(62);
    }

    protected void expressElementEnd(String qualifiedName) throws IOException {
        if (qualifiedName == null) {
            this.log.fatal((Object)"[expressElementEnd]Qualified name is null.");
            throw new RuntimeException("Qualified name is null.");
        }
        this.writer.write("</");
        this.writer.write(qualifiedName);
        this.writer.write(62);
    }

    protected void expressElementEnd() throws IOException {
        this.writer.write("/>");
    }

    protected void expressBodyText(String text) throws IOException {
        if (text == null) {
            this.log.error((Object)"[expressBodyText]Body text is null");
        } else {
            this.writer.write(this.escapeBodyValue(text));
        }
    }

    protected void expressAttribute(String qualifiedName, String value) throws IOException {
        if (value == null) {
            this.log.error((Object)"Null attribute value.");
            return;
        }
        if (qualifiedName == null) {
            this.log.error((Object)"Null attribute value.");
            return;
        }
        this.writer.write(32);
        this.writer.write(qualifiedName);
        this.writer.write("=\"");
        this.writer.write(this.escapeAttributeValue(value));
        this.writer.write(34);
    }

    protected void writePrintln() throws IOException {
        if (this.endOfLine != null) {
            this.writer.write(this.endOfLine);
        }
    }

    protected void writeIndent() throws IOException {
        if (this.indent != null) {
            int i = 0;
            while (i < this.getIndentLevel()) {
                this.writer.write(this.getIndent());
                ++i;
            }
        }
    }

    protected String escapeBodyValue(Object value) {
        StringBuffer buffer = new StringBuffer(value.toString());
        int i = 0;
        int size = buffer.length();
        while (i < size) {
            switch (buffer.charAt(i)) {
                case '<': {
                    buffer.replace(i, i + 1, LESS_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    break;
                }
                case '>': {
                    buffer.replace(i, i + 1, GREATER_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    break;
                }
                case '&': {
                    buffer.replace(i, i + 1, AMPERSAND_ENTITY);
                    size += 4;
                    i += 4;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String escapeAttributeValue(Object value) {
        StringBuffer buffer = new StringBuffer(value.toString());
        int i = 0;
        int size = buffer.length();
        while (i < size) {
            switch (buffer.charAt(i)) {
                case '<': {
                    buffer.replace(i, i + 1, LESS_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    break;
                }
                case '>': {
                    buffer.replace(i, i + 1, GREATER_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    break;
                }
                case '&': {
                    buffer.replace(i, i + 1, AMPERSAND_ENTITY);
                    size += 4;
                    i += 4;
                    break;
                }
                case '\'': {
                    buffer.replace(i, i + 1, APOSTROPHE_ENTITY);
                    size += 4;
                    i += 4;
                    break;
                }
                case '\"': {
                    buffer.replace(i, i + 1, QUOTE_ENTITY);
                    size += 5;
                    i += 5;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

