/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.ashkelon;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PackageTool {
    public static int countJavaFiles(File dir) {
        FileFilter ff = new FileFilter(){

            public boolean accept(File pathname) {
                String path = pathname.getName().toLowerCase();
                return path.endsWith(".java");
            }
        };
        File[] f = dir.listFiles(ff);
        return f.length;
    }

    public List findPackages(File startDir) {
        List results = this.internalFindPackages(new ArrayList(), startDir);
        ArrayList<String> packages = new ArrayList<String>(results.size());
        Iterator resultsIter = results.iterator();
        while (resultsIter.hasNext()) {
            File f = (File)resultsIter.next();
            String n = f.getAbsolutePath();
            if (n.equals(startDir.getAbsolutePath())) {
                packages.add("");
                continue;
            }
            n = n.substring(startDir.getAbsolutePath().length() + 1);
            n = n.replace('/', '.');
            n = n.replace('\\', '.');
            packages.add(n);
        }
        return packages;
    }

    public File[] getSubDir(File dir) {
        FileFilter ff = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        return dir.listFiles(ff);
    }

    protected List internalFindPackages(List results, File startDir) {
        if (PackageTool.countJavaFiles(startDir) != 0) {
            results.add(startDir);
        }
        File[] subdirs = this.getSubDir(startDir);
        int i = 0;
        while (i < subdirs.length) {
            this.internalFindPackages(results, subdirs[i]);
            ++i;
        }
        return results;
    }
}

