/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.linkcheck.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.linkcheck.validation.LinkValidationItem;
import org.apache.maven.linkcheck.validation.LinkValidationResult;
import org.apache.maven.linkcheck.validation.LinkValidator;
import org.apache.maven.linkcheck.validation.LinkValidatorCache;

public class LinkValidatorManager {
    private static Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$linkcheck$validation$LinkValidatorManager == null ? (class$org$apache$maven$linkcheck$validation$LinkValidatorManager = LinkValidatorManager.class$("org.apache.maven.linkcheck.validation.LinkValidatorManager")) : class$org$apache$maven$linkcheck$validation$LinkValidatorManager));
    private List validators = new ArrayList();
    private LinkValidatorCache cache = new LinkValidatorCache(this);
    private String exclude;
    static /* synthetic */ Class class$org$apache$maven$linkcheck$validation$LinkValidatorManager;

    public void addLinkValidator(LinkValidator lv) {
        this.validators.add(lv);
    }

    public List getValidators() {
        return this.validators;
    }

    public LinkValidationResult validateLink(LinkValidationItem lvi) throws Exception {
        LinkValidationResult status = this.cache.getCachedResult(lvi);
        if (status != null) {
            return status;
        }
        if (this.exclude != null && lvi.getLink().startsWith(this.exclude)) {
            return new LinkValidationResult(2, false);
        }
        Iterator iter = this.validators.iterator();
        while (iter.hasNext()) {
            LinkValidationResult lvr;
            LinkValidator lv = (LinkValidator)iter.next();
            Object resourceKey = lv.getResourceKey(lvi);
            if (resourceKey == null || (lvr = lv.validateLink(lvi)).getStatus() == 0) continue;
            this.cache.setCachedResult(resourceKey, lvr);
            return lvr;
        }
        LOG.info((Object)("Unable to validate link : " + lvi.getLink()));
        return new LinkValidationResult(3, false);
    }

    public void loadCache(String cacheFilename) {
        try {
            File f = new File(cacheFilename);
            if (f.exists()) {
                this.cache.load(new FileInputStream(cacheFilename));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void saveCache(String cacheFilename) {
        try {
            File cacheFile = new File(cacheFilename);
            File dir = cacheFile.getParentFile();
            if (dir != null) {
                dir.mkdirs();
            }
            this.cache.save(new FileOutputStream(cacheFilename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

