/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.apache.maven.repository.Artifact;
import org.apache.maven.repository.DefaultArtifactFactory;

public class ArtifactListBuilder {
    public static List build(Project project) {
        ArrayList<Artifact> projectArtifacts = new ArrayList<Artifact>();
        boolean mavenJarOverride = project.getContext().getMavenJarOverride();
        Iterator i = project.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency d = (Dependency)i.next();
            String mavenJarProperty = project.getContext().getMavenJarOverride(Project.standardToLegacyId(d.getId()));
            Artifact artifact = DefaultArtifactFactory.createArtifact(d);
            if (mavenJarOverride && StringUtils.isNotEmpty((String)mavenJarProperty)) {
                if (Character.isDigit(mavenJarProperty.charAt(0))) {
                    d.setVersion(mavenJarProperty);
                    artifact.setPath(project.getContext().getMavenRepoLocal() + artifact.generatePath());
                } else {
                    artifact.setPath(new File(mavenJarProperty).getAbsolutePath());
                }
            } else {
                artifact.setPath(project.getContext().getMavenRepoLocal() + artifact.generatePath());
            }
            projectArtifacts.add(artifact);
        }
        return projectArtifacts;
    }
}

