/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.GoalException;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.Project;

public class MavenSession
extends AbstractMavenComponent {
    public static final String BUILD_START_GOAL = "build:start";
    public static final String BUILD_END_GOAL = "build:end";
    public static final String DRIVER_SCRIPT_NAME = "driver.jelly";
    public static final String APP_VERSION = "1.1-SNAPSHOT";
    private MavenJellyContext rootContext;
    private static File rootDescriptorFile;
    private Project rootProject;
    private PluginManager pluginManager;
    private List goalNames = new ArrayList();

    public MavenSession() {
        this.pluginManager = new PluginManager(this);
    }

    public void setRootContext(MavenJellyContext rootContext) {
        this.rootContext = rootContext;
    }

    public MavenJellyContext getRootContext() {
        return this.rootContext;
    }

    public static void setRootDescriptorFile(File descriptorFile) {
        rootDescriptorFile = descriptorFile;
    }

    public static File getRootDescriptorFile() {
        return rootDescriptorFile;
    }

    public void setRootProject(Project rootProject) {
        this.rootProject = rootProject;
    }

    public Project getRootProject() {
        return this.rootProject;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public List getGoalNames() {
        return this.goalNames;
    }

    public void addGoalName(String goalName) {
        this.goalNames.add(goalName);
    }

    public void addGoalNames(List goalNames) {
        this.goalNames.addAll(goalNames);
    }

    public void clearGoalNames() {
        int i = 0;
        while (i < this.goalNames.size()) {
            this.goalNames.remove(i);
            ++i;
        }
    }

    public void initialize() throws Exception {
        this.initializePluginManager();
        this.initializeRootProject();
    }

    public void prepForGoal(String goalName, Project project) throws Exception {
        this.getPluginManager().prepForGoal(goalName, project);
    }

    public Set getAllGoalNames() {
        return this.getPluginManager().getGoalNames();
    }

    public String getGoalDescription(String goalName) {
        return this.getPluginManager().getGoalDescription(goalName);
    }

    public void loadJellyScript(File jellyScript, Project project) throws Exception {
        this.getPluginManager().loadJellyScript(jellyScript, project);
    }

    private void initializePluginManager() throws Exception {
        this.getPluginManager().initialize();
    }

    private void initializeRootProject() throws Exception {
        File descriptorFile = MavenSession.getRootDescriptorFile();
        this.getRootContext().setMavenSession(this);
        if (descriptorFile.exists()) {
            if (descriptorFile.length() == 0L) {
                throw new Exception(MavenUtils.getMessage("empty.descriptor.error", descriptorFile.getName()));
            }
            this.setRootProject(MavenUtils.getProject(descriptorFile, this.getRootContext()));
        } else {
            Project globalProject = new Project();
            globalProject.setId("Global Project");
            this.getRootContext().setProject(globalProject);
            globalProject.setContext(this.getRootContext());
            this.setRootProject(globalProject);
        }
        this.getRootProject().setGoalNames(this.getGoalNames());
    }

    public void attainGoals() throws GoalException, Exception {
        this.getPluginManager().attainGoals(this.getRootProject());
    }

    public void attainGoals(Project project) throws GoalException, Exception {
        this.getPluginManager().attainGoals(project);
    }
}

