/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.maven.jelly.tags.BaseTagSupport;

public class RootRelativePathTag
extends BaseTagSupport {
    private File rootdir;
    private String path;
    private String var;

    public void setRootdir(File rootdir) {
        this.rootdir = rootdir;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        String result;
        this.checkAttribute(this.rootdir, "rootdir");
        this.checkAttribute(this.path, "path");
        this.checkAttribute(this.var, "var");
        try {
            result = this.computePath();
        }
        catch (IOException e) {
            throw new JellyTagException("Unable to create relative path", (Throwable)e);
        }
        this.getContext().setVariable(this.var, (Object)result);
    }

    public String computePath() throws IOException {
        String canonicalRootdir = this.rootdir.getCanonicalPath();
        String canonicalPath = new File(this.path).getCanonicalPath();
        if (canonicalPath.equals(canonicalRootdir)) {
            return ".";
        }
        if (!canonicalPath.startsWith(canonicalRootdir)) {
            throw new IOException("Path [" + canonicalPath + "] is not a subset of [" + canonicalRootdir + "]");
        }
        canonicalPath = canonicalPath.substring(canonicalRootdir.length());
        StringBuffer result = new StringBuffer(".");
        StringTokenizer tokens = new StringTokenizer(canonicalPath, "/\\");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append("/..");
        }
        return result.toString();
    }
}

