/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.logging;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.plexus.factory.AbstractPlexusFactory;
import org.apache.plexus.logging.LoggerManager;

public class LoggerManagerFactory
extends AbstractPlexusFactory {
    public static LoggerManager create(Configuration defaultConfiguration, Configuration configuration, ClassLoader classLoader) throws Exception {
        String implementation;
        boolean loggingWithNoImplementationSpecified = false;
        if (configuration.getChild("logging", false) != null) {
            implementation = configuration.getChild("logging").getChild("implementation").getValue(null);
            if (implementation == null || implementation.trim().length() == 0) {
                loggingWithNoImplementationSpecified = true;
                implementation = defaultConfiguration.getChild("logging").getChild("implementation").getValue();
            }
        } else {
            implementation = defaultConfiguration.getChild("logging").getChild("implementation").getValue();
        }
        LoggerManager lm = (LoggerManager)AbstractPlexusFactory.getInstance(implementation, classLoader);
        lm.configure(configuration);
        lm.initialize();
        lm.start();
        if (loggingWithNoImplementationSpecified) {
            lm.getRootLogger().warn("A logging configuration was provided but no implementation was specified so the system has fallen back to the console logger manager.");
        }
        return lm;
    }
}

