/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.service.repository;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.plexus.PlexusContainer;
import org.apache.plexus.lifecycle.LifecycleHandler;
import org.apache.plexus.lifecycle.UndefinedLifecycleHandlerException;
import org.apache.plexus.logging.AbstractLogEnabled;
import org.apache.plexus.service.repository.ComponentDescriptor;
import org.apache.plexus.service.repository.ComponentHousing;
import org.apache.plexus.service.repository.ComponentManager;
import org.apache.plexus.service.repository.ComponentRepository;
import org.apache.plexus.service.repository.instance.InstanceManager;

public class DefaultComponentRepository
extends AbstractLogEnabled
implements ComponentRepository {
    private static String COMPONENTS = "components";
    private static String COMPONENT = "component";
    private static String ID = "id";
    private static String ROLE = "role";
    private static String ROLE_HINT = "role-hint";
    private static String IMPLEMENTATION = "implementation";
    private static String INSTANTIATION_STRATEGY = "instantiation-strategy";
    private static String CONFIGURATION = "configuration";
    protected static String PER_LOOKUP_STRATEGY = "per-lookup";
    protected static String POOLABLE_STRATEGY = "poolable";
    protected static String SINGLETON_STRATEGY = "singleton";
    private Configuration defaultConfiguration;
    private Configuration configuration;
    private Map componentDescriptors = new HashMap();
    private Map componentManagers = new HashMap();
    private Map componentHousings = new HashMap();
    private PlexusContainer plexusContainer;

    public void configure(Configuration defaultConfiguration, Configuration configuration) {
        this.defaultConfiguration = defaultConfiguration;
        this.configuration = configuration;
    }

    public void initialize() throws Exception {
        Configuration[] defaultComponentConfigurations = this.defaultConfiguration.getChild(COMPONENTS).getChildren(COMPONENT);
        int i = 0;
        while (i < defaultComponentConfigurations.length) {
            this.addComponentDescriptor(this.createComponentDescriptor(defaultComponentConfigurations[i]));
            ++i;
        }
        Configuration[] componentConfigurations = this.configuration.getChild(COMPONENTS).getChildren(COMPONENT);
        int i2 = 0;
        while (i2 < componentConfigurations.length) {
            this.addComponentDescriptor(this.createComponentDescriptor(componentConfigurations[i2]));
            ++i2;
        }
    }

    public PlexusContainer getPlexusContainer() {
        return this.plexusContainer;
    }

    public void setPlexusContainer(PlexusContainer plexusContainer) {
        this.plexusContainer = plexusContainer;
    }

    public ClassLoader getClassLoader() {
        return this.getPlexusContainer().getClassLoader();
    }

    public int configuredComponents() {
        return this.getComponentDescriptors().size();
    }

    public int instantiatedComponents() {
        return this.getComponentManagers().size();
    }

    Map getComponentDescriptors() {
        return this.componentDescriptors;
    }

    Map getComponentManagers() {
        return this.componentManagers;
    }

    ComponentManager getComponentManager(String componentKey) {
        return (ComponentManager)this.getComponentManagers().get(componentKey);
    }

    Map getComponentHousings() {
        return this.componentHousings;
    }

    ComponentManager instantiateComponentManager(ComponentDescriptor descriptor) throws Exception {
        ComponentDescriptor instantiationManagerDescriptor = (ComponentDescriptor)this.getComponentDescriptors().get(InstanceManager.ROLE + descriptor.getInstantiationStrategy());
        ComponentManager componentManager = new ComponentManager(descriptor, this, instantiationManagerDescriptor, this.getClassLoader());
        componentManager.initialize();
        this.getComponentManagers().put(descriptor.getComponentKey(), componentManager);
        return componentManager;
    }

    ComponentDescriptor createComponentDescriptor(Configuration configuration) throws Exception {
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setRole(configuration.getChild(ROLE).getValue());
        componentDescriptor.setRoleHint(configuration.getChild(ROLE_HINT).getValue(null));
        componentDescriptor.setImplementation(configuration.getChild(IMPLEMENTATION).getValue());
        componentDescriptor.setId(configuration.getChild(ID).getValue(null));
        componentDescriptor.setInstantiationStrategy(configuration.getChild(INSTANTIATION_STRATEGY).getValue(SINGLETON_STRATEGY));
        componentDescriptor.setConfiguration(configuration.getChild(CONFIGURATION));
        return componentDescriptor;
    }

    protected void addComponentDescriptor(ComponentDescriptor descriptor) {
        this.getComponentDescriptors().put(descriptor.getComponentKey(), descriptor);
    }

    public Object lookup(String key) throws ServiceException {
        ComponentManager componentManager = this.getComponentManager(key);
        Object component = null;
        if (componentManager == null) {
            ComponentDescriptor descriptor = (ComponentDescriptor)this.getComponentDescriptors().get(key);
            if (descriptor == null) {
                this.getLogger().error("Non existant component: " + key);
                throw new ServiceException(key, "Non existant component for key " + key + ".");
            }
            try {
                componentManager = this.instantiateComponentManager(descriptor);
            }
            catch (Exception e) {
                this.getLogger().error("Could not create component: " + key, (Throwable)e);
                throw new ServiceException(key, "Could not create component for key " + key + "!", (Throwable)e);
            }
            ComponentHousing housing = componentManager.getComponentHousing();
            if (housing == null) {
                throw new ServiceException(key, "ComponentHousing is null.");
            }
            component = componentManager.getComponentHousing().getComponent();
            if (component == null) {
                throw new ServiceException(key, "Component is null.");
            }
            this.getComponentHousings().put(component, housing);
        } else {
            component = componentManager.getComponentHousing().getComponent();
        }
        return component;
    }

    public Object lookup(String role, String id) throws ServiceException {
        return this.lookup(role + id);
    }

    public boolean hasService(String role) {
        return this.getComponentDescriptors().containsKey(role);
    }

    public boolean hasService(String role, String id) {
        return this.getComponentDescriptors().containsKey(role + id);
    }

    public void release(Object component) {
        ComponentHousing housing = (ComponentHousing)this.getComponentHousings().get(component);
        if (housing != null) {
            try {
                this.endComponentLifecycle(housing);
            }
            catch (Exception e) {
                this.getLogger().error("Error ending component lifecycle", (Throwable)e);
            }
            String serviceKey = housing.getComponentManager().getComponentDescriptor().getComponentKey();
            this.getComponentManagers().remove(serviceKey);
            this.getComponentHousings().remove(component);
            housing = null;
            component = null;
        }
    }

    public void dispose() {
        this.disposeAllComponents();
    }

    protected void disposeAllComponents() {
        Set roles = this.getComponentManagers().keySet();
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            String eachRole = (String)i.next();
            i.remove();
        }
    }

    protected LifecycleHandler getLifecycleHandler(String role) throws UndefinedLifecycleHandlerException {
        return this.getPlexusContainer().getLifecycleHandler();
    }

    public void startComponentLifecycle(ComponentHousing housing) {
        try {
            LifecycleHandler lh = this.getLifecycleHandler(housing.getComponentManager().getComponentDescriptor().getRole());
            lh.startLifecycle(housing);
        }
        catch (Exception e) {
            this.getLogger().error("Cannot start component lifecycle with role : " + housing.getComponentManager().getComponentDescriptor().getRole(), (Throwable)e);
        }
    }

    public void endComponentLifecycle(ComponentHousing housing) {
        try {
            LifecycleHandler lh = this.getLifecycleHandler(housing.getComponentManager().getComponentDescriptor().getRole());
            lh.endLifecycle(housing);
        }
        catch (Exception e) {
            this.getLogger().error("Cannot start component lifecycle with role : " + housing.getComponentManager().getComponentDescriptor().getRole(), (Throwable)e);
        }
    }
}

