/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jira;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.project.Project;

public class JiraDownloader {
    private static Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$jira$JiraDownloader == null ? (class$org$apache$maven$jira$JiraDownloader = JiraDownloader.class$("org.apache.maven.jira.JiraDownloader")) : class$org$apache$maven$jira$JiraDownloader));
    private File output;
    private int nbEntriesMax;
    private Project project;
    static /* synthetic */ Class class$org$apache$maven$jira$JiraDownloader;

    public void setOutput(File output) {
        this.output = output;
    }

    public Object getProject() {
        return this.project;
    }

    public void setProject(Object project) {
        this.project = (Project)project;
    }

    public void setNbEntries(int nbEntries) {
        this.nbEntriesMax = nbEntries;
    }

    public void doExecute() throws Exception {
        if (this.getProject() == null) {
            throw new Exception("No project set.");
        }
        if (((Project)this.getProject()).getIssueTrackingUrl() == null) {
            throw new Exception("No issue tracking url set.");
        }
        String url = ((Project)this.getProject()).getIssueTrackingUrl();
        int pos = url.indexOf("?");
        String id = url.substring(pos + 4);
        url = url.substring(0, url.lastIndexOf("/"));
        String link = url + "/secure/IssueNavigator.jspa?view=rss&pid=" + id + "&sorter/field=issuekey&sorter/order=DESC&sorter/field=status&sorter/order=DESC&tempMax=" + String.valueOf(this.nbEntriesMax) + "&reset=true";
        MavenJellyContext ctx = ((Project)this.getProject()).getContext();
        String proxyHost = ctx.getProxyHost();
        String proxyPort = ctx.getProxyPort();
        String proxyUser = ctx.getProxyUserName();
        String proxyPass = ctx.getProxyPassword();
        try {
            HttpClient cl = new HttpClient();
            HostConfiguration hc = new HostConfiguration();
            if (proxyHost != null) {
                hc.setProxy(proxyHost, Integer.parseInt(proxyPort));
            }
            HttpState state = new HttpState();
            if (proxyUser != null && proxyPass != null) {
                state.setProxyCredentials(null, null, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPass));
            }
            cl.setHostConfiguration(hc);
            cl.setState(state);
            GetMethod gm = this.download(cl, link);
            StatusLine sl = gm.getStatusLine();
            if (sl == null) {
                LOG.info((Object)("Unknown error validating link : " + link));
                return;
            }
            if (gm.getStatusCode() == 302) {
                Header locationHeader = gm.getResponseHeader("Location");
                if (locationHeader == null) {
                    LOG.info((Object)"Site sent redirect, but did not set Location header");
                } else {
                    String newLink = locationHeader.getValue();
                    LOG.debug((Object)("Following 1 redirect to " + newLink));
                    gm = this.download(cl, newLink);
                }
            }
            if (gm.getStatusCode() != 200) {
                String msg = "Received: [" + gm.getStatusCode() + "] for " + link;
                LOG.info((Object)msg);
                System.out.println(msg);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Error accessing " + link));
            e.printStackTrace();
        }
    }

    private GetMethod download(HttpClient cl, String link) {
        GetMethod gm = new GetMethod(link);
        try {
            System.out.println("Downloading " + link);
            gm.setFollowRedirects(true);
            cl.executeMethod((HttpMethod)gm);
            String strGetResponseBody = gm.getResponseBodyAsString();
            PrintWriter pw = new PrintWriter(new FileWriter(this.output));
            pw.print(strGetResponseBody);
            pw.close();
        }
        catch (Exception e) {
            System.out.println("Error downloading " + link);
        }
        return gm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

