/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Expand {
    private File dest;
    private File source;
    private boolean overwrite = true;

    public void execute() throws Exception {
        this.expandFile(this.source, this.dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void expandFile(File srcF, File dir) {
        ZipInputStream zis = null;
        zis = new ZipInputStream(new FileInputStream(srcF));
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            this.extractFile(srcF, dir, zis, ze.getName(), new Date(ze.getTime()), ze.isDirectory());
        }
        Object var6_6 = null;
        if (zis == null) return;
        try {
            zis.close();
            return;
        }
        catch (IOException e) {}
        return;
        {
            catch (IOException ioe) {
                Object var6_7 = null;
                if (zis == null) return;
                try {
                    zis.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (zis == null) throw throwable;
            try {
                zis.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractFile(File srcF, File dir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws IOException {
        File f = this.resolveFile(dir, entryName);
        try {
            block12: {
                if (!this.overwrite && f.exists() && f.lastModified() >= entryDate.getTime()) {
                    return;
                }
                File dirF = f.getParentFile();
                dirF.mkdirs();
                if (isDirectory) {
                    f.mkdirs();
                } else {
                    byte[] buffer = new byte[1024];
                    int length = 0;
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(f);
                        while (true) {
                            if ((length = compressedInputStream.read(buffer)) < 0) {
                                fos.close();
                                fos = null;
                                Object var13_13 = null;
                                if (fos == null) break block12;
                                break;
                            }
                            fos.write(buffer, 0, length);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        if (fos == null) throw throwable;
                        try {
                            fos.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException e) {}
                    fos.close();
                }
            }
            f.setLastModified(entryDate.getTime());
            return;
        }
        catch (FileNotFoundException ex) {
            return;
        }
    }

    public void setDest(File d) {
        this.dest = d;
    }

    public void setSrc(File s) {
        this.source = s;
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public File resolveFile(File file, String filename) {
        if ((filename = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar)).startsWith(File.separator) || filename.length() >= 2 && Character.isLetter(filename.charAt(0)) && filename.charAt(1) == ':') {
            return this.normalize(filename);
        }
        if (file == null) {
            return new File(filename);
        }
        File helpFile = new File(file.getAbsolutePath());
        StringTokenizer tok = new StringTokenizer(filename, File.separator);
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (part.equals("..")) {
                if ((helpFile = helpFile.getParentFile()) != null) continue;
                String msg = "The file or path you specified (" + filename + ") is invalid relative to " + file.getPath();
                System.err.println(msg);
                return null;
            }
            if (part.equals(".")) continue;
            helpFile = new File(helpFile, part);
        }
        return new File(helpFile.getAbsolutePath());
    }

    public File normalize(String path) {
        String orig = path;
        path = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int colon = path.indexOf(":");
        if (!(path.startsWith(File.separator) || path.length() >= 2 && Character.isLetter(path.charAt(0)) && colon == 1)) {
            String msg = path + " is not an absolute path";
            System.err.println(msg);
            return null;
        }
        boolean dosWithDrive = false;
        String root = null;
        if (path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            dosWithDrive = true;
            char[] ca = path.replace('/', '\\').toCharArray();
            StringBuffer sbRoot = new StringBuffer();
            int i = 0;
            while (i < colon) {
                sbRoot.append(Character.toUpperCase(ca[i]));
                ++i;
            }
            sbRoot.append(':');
            if (colon + 1 < path.length()) {
                sbRoot.append(File.separatorChar);
            }
            root = sbRoot.toString();
            StringBuffer sbPath = new StringBuffer();
            int i2 = colon + 1;
            while (i2 < ca.length) {
                if (ca[i2] != '\\' || ca[i2] == '\\' && ca[i2 - 1] != '\\') {
                    sbPath.append(ca[i2]);
                }
                ++i2;
            }
            path = sbPath.toString().replace('\\', File.separatorChar);
        }
        Stack<String> s = new Stack<String>();
        s.push(root);
        StringTokenizer tok = new StringTokenizer(path, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    System.err.println("Cannot resolve path " + orig);
                    return null;
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.size()) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append(s.elementAt(i));
            ++i;
        }
        path = sb.toString();
        if (dosWithDrive) {
            path = path.replace('/', '\\');
        }
        return new File(path);
    }
}

