/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.ProxyOutputStream;

public class CountingOutputStream
extends ProxyOutputStream {
    private int count;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    public void write(byte[] b) throws IOException {
        this.count += b.length;
        super.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.count += len;
        super.write(b, off, len);
    }

    public void write(int b) throws IOException {
        ++this.count;
        super.write(b);
    }

    public int getCount() {
        return this.count;
    }
}

