/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.pacman;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.FileManager;
import org.apache.maven.jxr.pacman.JavaFile;
import org.apache.maven.jxr.pacman.PackageType;
import org.apache.tools.ant.DirectoryScanner;

public class PackageManager {
    private Hashtable directories = new Hashtable();
    private Hashtable packages = new Hashtable();
    private PackageType defaultPackage = new PackageType();

    public PackageType getPackageType(String name) {
        if (name == null) {
            return this.defaultPackage;
        }
        return (PackageType)this.packages.get(name);
    }

    public void addPackageType(PackageType packageType) {
        this.packages.put(packageType.getName(), packageType);
    }

    public Enumeration getPackageTypes() {
        return this.packages.elements();
    }

    private void parse(String directory) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        File baseDir = new File(directory);
        directoryScanner.setBasedir(baseDir);
        String[] includes = new String[]{"**/*.java"};
        directoryScanner.setIncludes(includes);
        directoryScanner.scan();
        String[] files = directoryScanner.getIncludedFiles();
        int j = 0;
        while (j < files.length) {
            PackageManager.log("parsing... " + files[j]);
            try {
                String fileName = new File(baseDir, files[j]).getAbsolutePath();
                JavaFile jfi = FileManager.getInstance().getFile(fileName);
                PackageType jp = this.getPackageType(jfi.getPackageType().getName());
                if (jp == null) {
                    this.addPackageType(jfi.getPackageType());
                    jp = jfi.getPackageType();
                }
                if (jfi.getClassType() != null && jfi.getClassType().getName() != null) {
                    jp.addClassType(jfi.getClassType());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++j;
        }
    }

    public void process(String directory) {
        if (this.directories.get(directory) == null) {
            this.parse(directory);
            this.directories.put(directory, directory);
        }
    }

    public void process(String[] directories) {
        int i = 0;
        while (i < directories.length) {
            this.process(directories[i]);
            ++i;
        }
    }

    public static final void log(String message) {
        System.out.println(" PackageManager -> " + message);
    }

    public void dump() {
        PackageManager.log("Dumping out PackageManager structure");
        Enumeration pts = this.getPackageTypes();
        while (pts.hasMoreElements()) {
            PackageType current = (PackageType)pts.nextElement();
            PackageManager.log(current.getName());
            Enumeration classes = current.getClassTypes();
            while (classes.hasMoreElements()) {
                ClassType currentClass = (ClassType)classes.nextElement();
                PackageManager.log("\t" + currentClass.getName());
            }
        }
    }
}

