/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jcoveragereport;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.jcoveragereport.Line;

public class Clazz {
    private String packageName = "";
    private String name;
    private String file;
    private String lineRate;
    private String branchRate;
    private Map lines = new HashMap();

    public Clazz() {
    }

    public Clazz(String longName) {
        this();
        int pos = longName.lastIndexOf(".");
        if (pos > 0) {
            this.packageName = longName.substring(0, pos);
            this.name = longName.substring(pos + 1);
        } else {
            this.name = longName;
        }
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void setLineRate(String lineRate) {
        this.lineRate = lineRate;
    }

    public String getLineRate() {
        return this.lineRate;
    }

    public void setBranchRate(String branchRate) {
        this.branchRate = branchRate;
    }

    public String getBranchRate() {
        try {
            if (new Double(this.lineRate) == 0.0) {
                return new String("0.0");
            }
        }
        catch (NumberFormatException nfe) {
            return new String("0");
        }
        return this.branchRate;
    }

    public void setLines(Collection lines) {
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            Line line = (Line)iter.next();
            this.lines.put(new Integer(line.getNumLine()), line);
        }
    }

    public Collection getLines() {
        return this.lines.values();
    }

    public void addLine(Line line) {
        this.lines.put(new Integer(line.getNumLine()), line);
    }

    public Map getLinesMap() {
        return this.lines;
    }
}

