/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jcoveragereport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.jcoveragereport.Clazz;
import org.apache.maven.jcoveragereport.ClazzComparator;
import org.apache.maven.jcoveragereport.Package;
import org.apache.maven.jcoveragereport.PackageComparator;

public class Coverage {
    private List classes = new ArrayList();
    private String srcDirectory;
    private Map packageMap = new HashMap();

    public void setClasses(List classes) {
        this.classes = classes;
    }

    public void addClass(Clazz theClass) {
        this.classes.add(theClass);
        String packageName = theClass.getPackageName();
        Package pkg = !this.packageMap.containsKey(packageName) ? new Package(packageName) : (Package)this.packageMap.get(packageName);
        if (!pkg.contains(theClass)) {
            pkg.setDirectory(theClass.getFile().substring(0, theClass.getFile().lastIndexOf("/")));
            pkg.addClass(theClass);
            this.packageMap.put(packageName, pkg);
        }
    }

    public List getClasses() {
        return this.classes;
    }

    public List getClassesSortedByName() {
        ClazzComparator comp = new ClazzComparator();
        Collections.sort(this.classes, comp);
        return this.classes;
    }

    public void setSrcDirectory(String srcDirectory) {
        this.srcDirectory = srcDirectory;
    }

    public String getSrcDirectory() {
        return this.srcDirectory;
    }

    public List getPackages() {
        return new ArrayList(this.packageMap.values());
    }

    public List getPackagesSortedByName() {
        PackageComparator comp = new PackageComparator();
        List packages = this.getPackages();
        Collections.sort(packages, comp);
        return packages;
    }

    public List getSubPackage(Package thePackage) {
        ArrayList<Package> subPkgList = new ArrayList<Package>();
        Iterator iter = this.getPackagesSortedByName().iterator();
        while (iter.hasNext()) {
            Package pkg = (Package)iter.next();
            if (!pkg.getName().startsWith(thePackage.getName()) || pkg.getName().equals(thePackage.getName())) continue;
            subPkgList.add(pkg);
        }
        return subPkgList;
    }

    public String getCoveredPercentLine() {
        return String.valueOf(this.getLineCoverage());
    }

    public String getCoveredPercentBranch() {
        double total = 0.0;
        if (this.getLineCoverage() > 0.0) {
            Iterator iter = this.getClasses().iterator();
            while (iter.hasNext()) {
                Clazz theClass = (Clazz)iter.next();
                double rate = 0.0;
                try {
                    rate = new Double(theClass.getBranchRate()).floatValue();
                }
                catch (NumberFormatException e) {
                    rate = 0.0;
                }
                total += rate;
            }
        }
        return String.valueOf(total / (double)this.getClasses().size());
    }

    private double getLineCoverage() {
        double total = 0.0;
        Iterator iter = this.getClasses().iterator();
        while (iter.hasNext()) {
            Clazz theClass = (Clazz)iter.next();
            double rate = 0.0;
            try {
                rate = new Double(theClass.getLineRate()).floatValue();
            }
            catch (NumberFormatException e) {
                rate = 0.0;
            }
            total += rate;
        }
        return total / (double)this.getClasses().size();
    }
}

