/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Expression;
import org.apache.commons.betwixt.io.CyclicReferenceException;
import org.apache.commons.betwixt.io.IDGenerator;
import org.apache.commons.betwixt.io.id.SequentialIDGenerator;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public abstract class AbstractBeanWriter {
    private XMLIntrospector introspector = new XMLIntrospector();
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$AbstractBeanWriter == null ? (class$org$apache$commons$betwixt$io$AbstractBeanWriter = AbstractBeanWriter.class$("org.apache.commons.betwixt.io.AbstractBeanWriter")) : class$org$apache$commons$betwixt$io$AbstractBeanWriter));
    private HashMap idMap = new HashMap();
    private ArrayStack beanStack = new ArrayStack();
    private IDGenerator idGenerator = new SequentialIDGenerator();
    private boolean writeIDs = true;
    private int indentLevel;
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$AbstractBeanWriter;

    public void start() throws IOException, SAXException {
    }

    public void end() throws IOException, SAXException {
    }

    public void write(Object bean) throws IOException, SAXException, IntrospectionException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Writing bean graph...");
            this.log.debug(bean);
        }
        this.start();
        this.write(null, bean);
        this.end();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Finished writing bean graph.");
        }
    }

    public void write(String qualifiedName, Object bean) throws IOException, SAXException, IntrospectionException {
        ElementDescriptor elementDescriptor;
        XMLBeanInfo beanInfo;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Writing bean graph (qualified name '" + qualifiedName + "'"));
        }
        if ((beanInfo = this.introspector.introspect(bean)) != null && (elementDescriptor = beanInfo.getElementDescriptor()) != null) {
            Context context = new Context(bean, this.log);
            if (qualifiedName == null) {
                qualifiedName = elementDescriptor.getQualifiedName();
            }
            String ref = null;
            String id = null;
            if (elementDescriptor.isPrimitiveType()) {
                this.write(qualifiedName, elementDescriptor, context);
            } else {
                this.pushBean(context.getBean());
                if (this.writeIDs) {
                    ref = (String)this.idMap.get(context.getBean());
                }
                if (ref == null) {
                    AttributeDescriptor idAttribute = beanInfo.getIDAttribute();
                    if (idAttribute == null) {
                        id = this.idGenerator.nextId();
                        this.idMap.put(bean, id);
                        if (this.writeIDs) {
                            this.write(qualifiedName, elementDescriptor, context, beanInfo.getIDAttributeName(), id);
                        } else {
                            this.write(qualifiedName, elementDescriptor, context);
                        }
                    } else {
                        Object exp = idAttribute.getTextExpression().evaluate(context);
                        if (exp == null) {
                            this.log.debug((Object)"Using random id");
                            id = this.idGenerator.nextId();
                        } else {
                            id = exp.toString();
                        }
                        this.idMap.put(bean, id);
                        this.write(qualifiedName, elementDescriptor, context);
                    }
                } else {
                    this.writeIDREFElement(qualifiedName, beanInfo.getIDREFAttributeName(), ref);
                }
                this.popBean();
            }
        }
        this.log.trace((Object)"Finished writing bean graph.");
    }

    public IDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    protected int getIndentLevel() {
        return this.indentLevel;
    }

    public void setIdGenerator(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public boolean getWriteIDs() {
        return this.writeIDs;
    }

    public void setWriteIDs(boolean writeIDs) {
        this.writeIDs = writeIDs;
    }

    public XMLIntrospector getXMLIntrospector() {
        return this.introspector;
    }

    public void setXMLIntrospector(XMLIntrospector introspector) {
        this.introspector = introspector;
    }

    public final Log getAbstractBeanWriterLog() {
        return this.log;
    }

    public final void setAbstractBeanWriterLog(Log log) {
        this.log = log;
    }

    protected abstract void expressElementStart(String var1) throws IOException, SAXException;

    protected abstract void expressTagClose() throws IOException, SAXException;

    protected abstract void expressElementEnd(String var1) throws IOException, SAXException;

    protected abstract void expressElementEnd() throws IOException, SAXException;

    protected abstract void expressBodyText(String var1) throws IOException, SAXException;

    protected abstract void expressAttribute(String var1, String var2) throws IOException, SAXException;

    protected void write(String qualifiedName, ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException, IntrospectionException {
        if (elementDescriptor.isWrapCollectionsInElement()) {
            this.expressElementStart(qualifiedName);
        }
        this.writeRestOfElement(qualifiedName, elementDescriptor, context);
    }

    protected void write(String qualifiedName, ElementDescriptor elementDescriptor, Context context, String idAttribute, String idValue) throws IOException, SAXException, IntrospectionException {
        this.expressElementStart(qualifiedName);
        this.expressAttribute(idAttribute, idValue);
        this.writeRestOfElement(qualifiedName, elementDescriptor, context);
    }

    protected void writeRestOfElement(String qualifiedName, ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException, IntrospectionException {
        if (elementDescriptor.isWrapCollectionsInElement()) {
            this.writeAttributes(elementDescriptor, context);
        }
        if (this.writeContent(elementDescriptor, context)) {
            if (elementDescriptor.isWrapCollectionsInElement()) {
                this.expressElementEnd(qualifiedName);
            }
        } else if (elementDescriptor.isWrapCollectionsInElement()) {
            this.expressElementEnd();
        }
    }

    protected void writeIDREFElement(String qualifiedName, String idrefAttributeName, String idrefAttributeValue) throws IOException, SAXException, IntrospectionException {
        this.expressElementStart(qualifiedName);
        this.expressAttribute(idrefAttributeName, idrefAttributeValue);
        this.expressElementEnd();
    }

    protected boolean writeContent(ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException, IntrospectionException {
        ElementDescriptor[] childDescriptors = elementDescriptor.getElementDescriptors();
        boolean writtenContent = false;
        if (childDescriptors != null && childDescriptors.length > 0) {
            int i = 0;
            int size = childDescriptors.length;
            while (i < size) {
                ElementDescriptor childDescriptor = childDescriptors[i];
                Context childContext = context;
                Expression childExpression = childDescriptor.getContextExpression();
                if (childExpression != null) {
                    Object childBean = childExpression.evaluate(context);
                    if (childBean != null) {
                        String qualifiedName = childDescriptor.getQualifiedName();
                        if (childBean instanceof Iterator) {
                            Iterator iter = (Iterator)childBean;
                            while (iter.hasNext()) {
                                Object object = iter.next();
                                if (object == null) continue;
                                if (!writtenContent) {
                                    writtenContent = true;
                                    if (elementDescriptor.isWrapCollectionsInElement()) {
                                        this.expressTagClose();
                                    }
                                }
                                ++this.indentLevel;
                                this.write(qualifiedName, object);
                                --this.indentLevel;
                            }
                        } else {
                            if (!writtenContent) {
                                writtenContent = true;
                                this.expressTagClose();
                            }
                            ++this.indentLevel;
                            this.write(qualifiedName, childBean);
                            --this.indentLevel;
                        }
                    }
                } else {
                    if (!writtenContent) {
                        writtenContent = true;
                        this.expressTagClose();
                    }
                    if (childDescriptor.isWrapCollectionsInElement()) {
                        ++this.indentLevel;
                    }
                    this.write(childDescriptor.getQualifiedName(), childDescriptor, childContext);
                    if (childDescriptor.isWrapCollectionsInElement()) {
                        --this.indentLevel;
                    }
                }
                ++i;
            }
            if (writtenContent) {
                this.writePrintln();
                this.writeIndent();
            }
        } else {
            String text;
            Object value;
            Expression expression = elementDescriptor.getTextExpression();
            if (expression != null && (value = expression.evaluate(context)) != null && (text = value.toString()) != null && text.length() > 0) {
                if (!writtenContent) {
                    writtenContent = true;
                    this.expressTagClose();
                }
                this.expressBodyText(text);
            }
        }
        return writtenContent;
    }

    protected void writeAttributes(ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException {
        if (!elementDescriptor.isWrapCollectionsInElement()) {
            return;
        }
        AttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributeDescriptors();
        if (attributeDescriptors != null) {
            int i = 0;
            int size = attributeDescriptors.length;
            while (i < size) {
                AttributeDescriptor attributeDescriptor = attributeDescriptors[i];
                this.writeAttribute(attributeDescriptor, context);
                ++i;
            }
        }
    }

    protected void writeAttribute(AttributeDescriptor attributeDescriptor, Context context) throws IOException, SAXException {
        String text;
        Object value;
        Expression expression = attributeDescriptor.getTextExpression();
        if (expression != null && (value = expression.evaluate(context)) != null && (text = value.toString()) != null && text.length() > 0) {
            this.expressAttribute(attributeDescriptor.getQualifiedName(), text);
        }
    }

    protected void writePrintln() throws IOException {
    }

    protected void writeIndent() throws IOException {
    }

    protected void pushBean(Object bean) {
        if (!this.writeIDs) {
            Iterator it = this.beanStack.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (bean != next) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Element stack: ");
                    Iterator debugStack = this.beanStack.iterator();
                    while (debugStack.hasNext()) {
                        this.log.debug(debugStack.next());
                    }
                }
                this.log.error((Object)("Cyclic reference at bean: " + bean));
                throw new CyclicReferenceException();
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Pushing onto object stack: " + bean));
        }
        this.beanStack.push(bean);
    }

    protected Object popBean() {
        Object bean = this.beanStack.pop();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Popped from object stack: " + bean));
        }
        return bean;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

