/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import com.werken.forehead.ForeheadClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.betwixt.strategy.DecapitalizeNameMapper;
import org.apache.commons.betwixt.strategy.NameMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.CompositeExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jelly.JellyUtils;
import org.apache.maven.jelly.MavenExpressionFactory;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.project.BaseObject;
import org.apache.maven.project.Project;
import org.apache.maven.util.StringInputStream;
import org.apache.tools.ant.DirectoryScanner;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MavenUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$MavenUtils == null ? (class$org$apache$maven$MavenUtils = MavenUtils.class$("org.apache.maven.MavenUtils")) : class$org$apache$maven$MavenUtils));
    private static final String INTERNAL_ENCODING = "ISO-8859-1";
    private static final ThreadLocal xmlReaderPool = new ThreadLocal();
    private static boolean cacheIntrospector = true;
    private static XMLIntrospector singletonIntrospector;
    private static BeanReader projectBeanReader;
    private static MavenExpressionFactory mavenExpressionFactory;
    private static HashMap parentPoms;
    private static ResourceBundle messages;
    static /* synthetic */ Class class$org$apache$maven$MavenUtils;
    static /* synthetic */ Class class$org$apache$maven$project$Project;

    public static Project getProject(File projectDescriptor) throws Exception {
        return MavenUtils.getProject(projectDescriptor, null);
    }

    public static Project getProject(File projectDescriptor, MavenJellyContext parentContext) throws Exception {
        return MavenUtils.getProject(projectDescriptor, parentContext, true);
    }

    public static Project getProject(File projectDescriptor, MavenJellyContext parentContext, boolean useParentPom) throws Exception {
        Project project = MavenUtils.getNonJellyProject(projectDescriptor, parentContext, useParentPom);
        project = MavenUtils.getJellyProject(project);
        project.setFile(projectDescriptor);
        project.initialize();
        return project;
    }

    private static Project getNonJellyProject(File projectDescriptor, MavenJellyContext parentContext, boolean useParentPom) throws Exception {
        Project project = (Project)MavenUtils.getProjectBeanReader().parse(projectDescriptor);
        MavenJellyContext context = MavenUtils.createContext(projectDescriptor.getParentFile(), parentContext);
        String pomToExtend = project.getExtend();
        if (pomToExtend != null && useParentPom) {
            Expression e = JellyUtils.decomposeExpression(pomToExtend, mavenExpressionFactory, context);
            pomToExtend = e.evaluateAsString((JellyContext)context);
            pomToExtend = MavenUtils.makeAbsolutePath(projectDescriptor.getParentFile(), pomToExtend);
            project.setExtend(pomToExtend);
            File parentPom = new File(pomToExtend);
            Project parent = (Project)parentPoms.get(parentPom.getCanonicalPath());
            if (parent == null) {
                parent = MavenUtils.getNonJellyProject(parentPom, parentContext, true);
                parent.setFile(parentPom);
                parentPoms.put(parentPom.getCanonicalPath(), parent);
                context.setParent(parent.getContext());
            }
            Properties properties = MavenUtils.loadProjectBuildProperties(parentPom.getParentFile());
            MavenUtils.integrateMapInContext(properties, context);
            properties = MavenUtils.loadProjectProperties(parentPom.getParentFile());
            MavenUtils.integrateMapInContext(properties, context);
            project.mergeParent(parent);
        }
        project.setContext(context);
        context.setProject(project);
        return project;
    }

    public static List getProjects(File directory, String includes, String excludes) throws Exception {
        return MavenUtils.getProjects(directory, includes, excludes, null);
    }

    public static List getProjects(File directory, String includes, String excludes, MavenJellyContext context) throws Exception {
        String[] files = MavenUtils.getFiles(directory, includes, excludes);
        ArrayList<Project> projects = new ArrayList<Project>();
        int i = 0;
        while (i < files.length) {
            Project p = MavenUtils.getProject(new File(files[i]), context);
            projects.add(p);
            ++i;
        }
        return projects;
    }

    private static BeanReader getProjectBeanReader() throws Exception {
        if (projectBeanReader == null) {
            projectBeanReader = MavenUtils.createBeanReader(class$org$apache$maven$project$Project == null ? (class$org$apache$maven$project$Project = MavenUtils.class$("org.apache.maven.project.Project")) : class$org$apache$maven$project$Project);
        }
        return projectBeanReader;
    }

    private static Project getJellyProject(Project project) throws Exception {
        MavenJellyContext originalContext = project.getContext();
        JellyContext context = new JellyContext();
        context.setVariables(originalContext.getVariables());
        project.setContext(null);
        Project parent = project.getParent();
        project.setParent(null);
        project = MavenUtils.getInterpolatedPOM(project, context);
        project.setParent(parent);
        project.setContext(originalContext);
        project.getContext().setProject(project);
        return project;
    }

    private static Project getInterpolatedPOM(Project project, JellyContext context) throws Exception, IOException, SAXException {
        String projectString = MavenUtils.getProjectString(project);
        Expression e = JellyUtils.decomposeExpression(projectString, mavenExpressionFactory, context);
        String newProjectString = e.evaluateAsString(context);
        project = (Project)MavenUtils.getProjectBeanReader().parse((Reader)new StringReader(newProjectString));
        return project;
    }

    public static InputStream getProjectInputStream(Project project) throws Exception {
        return new StringInputStream(MavenUtils.getProjectString(project));
    }

    public static String getProjectString(Project project) throws Exception {
        ByteArrayOutputStream projectStream = new ByteArrayOutputStream();
        BeanWriter beanWriter = new BeanWriter((OutputStream)projectStream);
        beanWriter.setXMLIntrospector(MavenUtils.createXMLIntrospector());
        beanWriter.setWriteIDs(true);
        beanWriter.write((Object)project);
        return projectStream.toString(System.getProperty("file.encoding"));
    }

    public static String[] getFiles(File directory, String includes) {
        return MavenUtils.getFiles(directory, includes, null);
    }

    public static String[] getFiles(File directory, String includes, String excludes) {
        String[] includePatterns = null;
        if (includes != null) {
            includePatterns = StringUtils.split((String)includes, (String)",");
        }
        String[] excludePatterns = null;
        if (excludes != null) {
            excludePatterns = StringUtils.split((String)excludes, (String)",");
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(directory);
        directoryScanner.setIncludes(includePatterns);
        directoryScanner.setExcludes(excludePatterns);
        directoryScanner.scan();
        String[] files = directoryScanner.getIncludedFiles();
        int i = 0;
        while (i < files.length) {
            files[i] = new File(directory, files[i]).getAbsolutePath();
            ++i;
        }
        return files;
    }

    public static BeanReader createBeanReader(Class clazz) throws Exception {
        BeanReader beanReader = new BeanReader(MavenUtils.getXMLReader());
        beanReader.setRules((Rules)new ExtendedBaseRules());
        beanReader.addRule("*/properties/?", (Rule)new MetaPropertiesRule());
        beanReader.setXMLIntrospector(MavenUtils.getXMLIntrospector());
        beanReader.registerBeanClass(clazz);
        return beanReader;
    }

    public static XMLIntrospector getXMLIntrospector() {
        if (cacheIntrospector) {
            if (singletonIntrospector == null) {
                singletonIntrospector = MavenUtils.createXMLIntrospector();
            }
            return singletonIntrospector;
        }
        return MavenUtils.createXMLIntrospector();
    }

    private static XMLIntrospector createXMLIntrospector() {
        XMLIntrospector introspector = new XMLIntrospector();
        introspector.setAttributesForPrimitives(false);
        introspector.setElementNameMapper((NameMapper)new DecapitalizeNameMapper());
        return introspector;
    }

    public static XMLReader getXMLReader() throws Exception {
        XMLReader parser = (XMLReader)xmlReaderPool.get();
        if (parser == null) {
            parser = MavenUtils.createXMLReader();
            xmlReaderPool.set(parser);
        }
        return parser;
    }

    private static XMLReader createXMLReader() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newSAXParser().getXMLReader();
    }

    public static Map mergeMaps(Map dominantMap, Map recessiveMap) {
        HashMap result = new HashMap();
        if (dominantMap == null && recessiveMap == null) {
            return null;
        }
        if (dominantMap != null && recessiveMap == null) {
            return dominantMap;
        }
        if (dominantMap == null) {
            return recessiveMap;
        }
        Set dominantMapKeys = dominantMap.keySet();
        Set recessiveMapKeys = recessiveMap.keySet();
        Collection contributingRecessiveKeys = CollectionUtils.subtract(recessiveMapKeys, (Collection)CollectionUtils.intersection(dominantMapKeys, recessiveMapKeys));
        result.putAll(dominantMap);
        Iterator i = contributingRecessiveKeys.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            result.put(key, recessiveMap.get(key));
        }
        return result;
    }

    public static Map mergeMaps(Map[] maps) {
        Map result;
        if (maps.length == 0) {
            result = null;
        } else if (maps.length == 1) {
            result = maps[0];
        } else {
            result = MavenUtils.mergeMaps(maps[0], maps[1]);
            int i = 2;
            while (i < maps.length) {
                result = MavenUtils.mergeMaps(result, maps[i]);
                ++i;
            }
        }
        return result;
    }

    private static Properties loadProjectBuildProperties(File directory) {
        File projectBuildPropertiesFile = new File(directory, "build.properties");
        log.debug((Object)("Using projectBuildPropertiesFile: " + projectBuildPropertiesFile.getAbsolutePath()));
        return MavenUtils.loadProperties(projectBuildPropertiesFile);
    }

    private static Properties loadProjectProperties(File directory) {
        File projectPropertiesFile = new File(directory, "project.properties");
        log.debug((Object)("Using projectPropertiesFile: " + projectPropertiesFile.getAbsolutePath()));
        return MavenUtils.loadProperties(projectPropertiesFile);
    }

    public static MavenJellyContext createContext(File descriptorDirectory) {
        return MavenUtils.createContext(descriptorDirectory, null);
    }

    public static MavenJellyContext createContext(File descriptorDirectory, MavenJellyContext parentContext) {
        MavenJellyContext context;
        Properties systemProperties = System.getProperties();
        File userBuildPropertiesFile = new File(System.getProperty("user.home"), "build.properties");
        log.debug((Object)("Using userBuildPropertiesFile: " + userBuildPropertiesFile.getAbsolutePath()));
        Properties userBuildProperties = MavenUtils.loadProperties(userBuildPropertiesFile);
        Properties projectProperties = MavenUtils.loadProjectProperties(descriptorDirectory);
        Properties projectBuildProperties = MavenUtils.loadProjectBuildProperties(descriptorDirectory);
        Properties driverProperties = MavenUtils.loadProperties((class$org$apache$maven$MavenUtils == null ? (class$org$apache$maven$MavenUtils = MavenUtils.class$("org.apache.maven.MavenUtils")) : class$org$apache$maven$MavenUtils).getResourceAsStream("/driver.properties"));
        Properties defaultProperties = MavenUtils.loadProperties((class$org$apache$maven$MavenUtils == null ? (class$org$apache$maven$MavenUtils = MavenUtils.class$("org.apache.maven.MavenUtils")) : class$org$apache$maven$MavenUtils).getResourceAsStream("/defaults.properties"));
        Map result = MavenUtils.mergeMaps(new Map[]{systemProperties, userBuildProperties, projectBuildProperties, projectProperties, driverProperties});
        if (parentContext != null) {
            context = new MavenJellyContext(parentContext);
            context.setInherit(false);
            MavenUtils.integrateMapInContext(result, context);
            context.setInherit(true);
            MavenUtils.integrateMapInContext(defaultProperties, context);
        } else {
            context = new MavenJellyContext();
            MavenUtils.integrateMapInContext(result, context);
            MavenUtils.integrateMapInContext(defaultProperties, context);
            context.setInherit(true);
        }
        context.setVariable("basedir", descriptorDirectory.getAbsolutePath());
        return context;
    }

    public static void integrateMapInContext(Map map, MavenJellyContext context) {
        if (map == null) {
            return;
        }
        JexlExpressionFactory factory = new JexlExpressionFactory();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (context.getVariable(key) != null) continue;
            String literalValue = (String)map.get(key);
            try {
                Expression expr = CompositeExpression.parse((String)literalValue, (ExpressionFactory)factory);
                Object value = expr != null ? expr : literalValue;
                context.setVariable(key, value);
            }
            catch (Exception e) {
                log.debug((Object)"Unexpected error evaluating expression", (Throwable)e);
            }
        }
    }

    private static Properties loadProperties(File file) {
        try {
            if (file.exists()) {
                return MavenUtils.loadProperties(new FileInputStream(file));
            }
        }
        catch (Exception e) {
            log.debug((Object)"Unexpected error loading properties", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(InputStream is) {
        try {
            Properties properties = new Properties();
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            log.debug((Object)"Unexpected exception loading properties", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.debug((Object)"Unexpected exception loading properties", (Throwable)e);
            }
        }
        return null;
    }

    private static void loadMessages() {
        try {
            messages = ResourceBundle.getBundle("org/apache/maven/messages/messages");
        }
        catch (MissingResourceException e) {
            messages = ResourceBundle.getBundle("org/apache/maven/messages/messages", Locale.ENGLISH);
        }
    }

    public static String getMessage(String messageId) {
        return MavenUtils.getMessage(messageId, null);
    }

    public static String getMessage(String messageId, Object variable) {
        if (messages == null) {
            MavenUtils.loadMessages();
        }
        if (variable == null) {
            return messages.getString(messageId);
        }
        return StringUtils.replace((String)messages.getString(messageId), (String)"${1}", (String)variable.toString());
    }

    public static String makeAbsolutePath(File basedir, String dir) throws IOException {
        File f = new File(dir);
        if (!f.isAbsolute()) {
            return new File(basedir, dir).getCanonicalPath();
        }
        return f.getCanonicalPath();
    }

    public static String makeRelativePath(File basedir, String path) throws IOException {
        String canonicalBasedir = basedir.getCanonicalPath();
        String canonicalPath = new File(path).getCanonicalPath();
        if (canonicalPath.equals(canonicalBasedir)) {
            return ".";
        }
        if (canonicalPath.startsWith(canonicalBasedir)) {
            canonicalPath = canonicalPath.charAt(canonicalBasedir.length()) == File.separatorChar ? canonicalPath.substring(canonicalBasedir.length() + 1) : canonicalPath.substring(canonicalBasedir.length());
        }
        return canonicalPath;
    }

    public static List getGoalListFromCsv(String goalCsv) {
        StringTokenizer tok = new StringTokenizer(goalCsv, ",");
        ArrayList<String> goals = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            goals.add(tok.nextToken());
        }
        return goals;
    }

    public static void displayClassLoaderContents(ForeheadClassLoader classLoader) {
        System.out.println("ClassLoader name: " + classLoader.getName());
        URL[] urls = classLoader.getURLs();
        int i = 0;
        while (i < urls.length) {
            System.out.println("urls[" + i + "] = " + urls[i]);
            ++i;
        }
        ClassLoader parent = classLoader.getParent();
        if (parent != null && parent instanceof ForeheadClassLoader) {
            System.out.println("Displaying Parent classloader: ");
            MavenUtils.displayClassLoaderContents((ForeheadClassLoader)classLoader.getParent());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mavenExpressionFactory = new MavenExpressionFactory();
        parentPoms = new HashMap();
    }

    static class MetaPropertiesRule
    extends Rule {
        private String value;

        public void body(String namespace, String name, String text) throws Exception {
            this.value = text;
        }

        public void end(String namespace, String elementName) throws Exception {
            BaseObject baseObject = (BaseObject)this.getDigester().peek();
            String name = this.getDigester().getCurrentElementName();
            baseObject.addProperty(name + ":" + this.value);
        }
    }
}

