/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import com.werken.werkz.NoActionDefinitionException;
import com.werken.werkz.UnattainableGoalException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.MavenSession;
import org.apache.maven.MavenUtils;
import org.apache.maven.NoGoalException;
import org.apache.maven.UnknownGoalException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.verifier.ChecksumVerificationException;
import org.apache.maven.verifier.RepoConfigException;
import org.apache.maven.verifier.UnsatisfiedDependencyException;

public class App {
    public static final String POM_FILE_NAME = "project.xml";
    private static final int CONSOLE_WIDTH = 80;
    private static final int RC_OK = 0;
    private static final int RC_BAD_ARG = 10;
    private static final int RC_INIT_ERROR = 20;
    private static final int RC_NO_GOAL = 30;
    private static final int RC_BAD_REPO = 40;
    private static final int RC_EMPTY_GOAL = 50;
    private static final int RC_GOAL_FAILED = 60;
    private static final int RC_JELLY_FAILED = 70;
    private static final int RC_BAD_JELLY = 80;
    private static final int RC_OTHER_FAILURE = 90;
    private static final int RC_FAILED_DEPENDENCY = 100;
    private static final String CONSOLE_BANNER = "b";
    private static final String DISPLAY_STACKTRACE = "e";
    private static final String FIND_POM_DESCRIPTOR = "f";
    private static final String DISPLAY_GOALS = "g";
    private static final String DISPLAY_HELP = "h";
    private static final String DISPLAY_INFO = "i";
    private static final String DISPLAY_VERSION = "v";
    private static final String WORK_OFFLINE = "o";
    private static final String SET_POM_DESCRIPTOR = "p";
    private static final String SET_SYSTEM_PROPERTY = "D";
    private static final String EMACS_OUTPUT = "E";
    private static final String QUIET = "q";
    private static final String DEBUG = "X";
    private static final String WORKING_DIR = "d";
    private CommandLine commandLine;
    private PrintStream consoleOut;
    private PrintStream consoleErr;
    private Writer writer;
    private MavenJellyContext rootContext;
    private MavenSession mavenSession;
    private Log log = LogFactory.getLog((Class)(class$org$apache$maven$cli$App == null ? (class$org$apache$maven$cli$App = App.class$("org.apache.maven.cli.App")) : class$org$apache$maven$cli$App));
    static /* synthetic */ Class class$org$apache$maven$cli$App;

    public void setRootContext(MavenJellyContext rootContext) {
        this.rootContext = rootContext;
    }

    public MavenJellyContext getRootContext() {
        return this.rootContext;
    }

    protected void setCli(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    protected CommandLine getCli() {
        return this.commandLine;
    }

    public void initialize(String[] args) throws ParseException, MalformedURLException, IOException, Exception {
        this.setCli(CLIManager.parse(args));
        this.initializeSystemProperties();
        this.initializeRootContext();
        this.initializeMavenSession();
    }

    private File getDescriptorFile() throws IOException {
        File descriptorFile = null;
        String descriptorName = null;
        descriptorName = this.getCli().hasOption(SET_POM_DESCRIPTOR) ? this.getCli().getOptionValue(SET_POM_DESCRIPTOR) : POM_FILE_NAME;
        if (this.getCli().hasOption(FIND_POM_DESCRIPTOR)) {
            descriptorFile = this.find(descriptorName);
            if (descriptorFile == null) {
                descriptorFile = new File(descriptorName);
            }
            System.setProperty("user.dir", descriptorFile.getParentFile().getCanonicalPath());
        } else {
            descriptorFile = new File(System.getProperty("user.dir"), descriptorName);
        }
        return descriptorFile;
    }

    protected void initializeRootContext() throws IOException {
        this.consoleOut = System.out;
        this.consoleErr = System.err;
        this.writer = new OutputStreamWriter(this.consoleOut);
        XMLOutput output = XMLOutput.createXMLOutput((Writer)this.writer, (boolean)false);
        if (this.getCli().hasOption(WORKING_DIR)) {
            String workingDir = this.getCli().getOptionValue(WORKING_DIR);
            System.setProperty("user.dir", workingDir);
        }
        MavenJellyContext c = MavenUtils.createContext(new File(System.getProperty("user.dir")));
        this.setRootContext(c);
        this.getRootContext().setXMLOutput(output);
        if (this.getCli().hasOption(QUIET)) {
            Logger.getLogger((String)"org.apache.maven").setLevel(Level.ERROR);
        }
        if (this.getCli().hasOption(DEBUG)) {
            this.getRootContext().setDebugOn(Boolean.TRUE);
            Logger.getLogger((String)"org.apache.maven").setLevel(Level.DEBUG);
        } else {
            this.getRootContext().setDebugOn(Boolean.FALSE);
        }
        if (this.getCli().hasOption(EMACS_OUTPUT)) {
            this.getRootContext().setEmacsModeOn(Boolean.TRUE);
        } else {
            this.getRootContext().setEmacsModeOn(Boolean.FALSE);
        }
        if (this.getCli().hasOption(WORK_OFFLINE)) {
            this.getRootContext().setOnline(Boolean.FALSE);
        } else {
            this.getRootContext().setOnline(Boolean.TRUE);
        }
    }

    private void initializeMavenSession() throws IOException {
        this.mavenSession = new MavenSession();
        this.mavenSession.setRootContext(this.getRootContext());
        MavenSession.setRootDescriptorFile(this.getDescriptorFile());
    }

    public void initializeSystemProperties() {
        if (this.getCli().hasOption(SET_SYSTEM_PROPERTY)) {
            String[] defStrs = this.getCli().getOptionValues(SET_SYSTEM_PROPERTY);
            int i = 0;
            while (i < defStrs.length) {
                this.setCliProperty(defStrs[i]);
                ++i;
            }
        }
    }

    private void setCliProperty(String defStr) {
        String name = null;
        String value = null;
        int equalLoc = defStr.indexOf("=");
        if (equalLoc <= 0) {
            name = defStr.trim();
            value = "true";
        } else {
            name = defStr.substring(0, equalLoc).trim();
            value = defStr.substring(equalLoc + 1).trim();
        }
        System.setProperty(name, value);
    }

    public void doMain(String[] args, Date fullStart) {
        this.initializeMain(args);
        this.displayHelp();
        this.displayInfo();
        this.displayVersion();
        int returnCode = 0;
        if (!this.getCli().hasOption(CONSOLE_BANNER)) {
            this.printConsoleMavenHeader();
        }
        boolean failed = false;
        try {
            this.mavenSession.initialize();
            if (this.getCli().hasOption(DISPLAY_GOALS)) {
                this.displayGoals();
                this.exit(returnCode);
            } else {
                this.mavenSession.attainGoals(this.mavenSession.getRootProject(), this.getCli().getArgList());
            }
        }
        catch (UnsatisfiedDependencyException e) {
            failed = true;
            System.err.println(e.getLocalizedMessage());
            returnCode = 100;
        }
        catch (ChecksumVerificationException e) {
            failed = true;
            System.err.println(e.getLocalizedMessage());
        }
        catch (UnknownGoalException e) {
            failed = true;
            System.err.println("BUILD FAILED");
            System.err.println("Goal \"" + e.getGoalName() + "\" does not exist in this project.");
            returnCode = 30;
        }
        catch (NoGoalException e) {
            failed = true;
            System.err.println("BUILD FAILED");
            System.err.println(e.getMessage());
            returnCode = 30;
        }
        catch (RepoConfigException e) {
            failed = true;
            System.err.println(e.getLocalizedMessage());
            returnCode = 40;
        }
        catch (NoActionDefinitionException e) {
            failed = true;
            System.err.println("INTERNAL ERROR");
            System.err.println("Reference made to goal '" + e.getGoal().getName() + "' which has no definition.");
            System.out.println("");
            returnCode = 50;
            return;
        }
        catch (UnattainableGoalException e) {
            failed = true;
            returnCode = this.handleUnattainableGoalException(e);
        }
        catch (JellyException e) {
            returnCode = 80;
            failed = true;
            String fileName = e.getFileName();
            String elementName = e.getElementName();
            int lineNumber = e.getLineNumber();
            int column = e.getColumnNumber();
            String msg = e.getReason();
            System.err.println("File...... " + fileName);
            System.err.println("Element... " + elementName);
            System.err.println("Line...... " + lineNumber);
            System.err.println("Column.... " + column);
            System.err.println(msg);
            if (this.getCli().hasOption(DISPLAY_STACKTRACE)) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            returnCode = 90;
            failed = true;
            e.printStackTrace();
        }
        if (!failed) {
            System.out.println("BUILD SUCCESSFUL");
        }
        Date fullStop = new Date();
        long fullDiff = fullStop.getTime() - fullStart.getTime();
        this.log.info((Object)("Total time: " + App.formatTime(fullDiff)));
        this.log.info((Object)("Finished at: " + fullStop));
        this.log.info((Object)"");
        this.exit(returnCode);
    }

    private void initializeMain(String[] args) {
        int returnCode = 0;
        try {
            this.initialize(args);
        }
        catch (ParseException e) {
            this.log.info((Object)e.getLocalizedMessage());
            CLIManager.displayHelp();
            returnCode = 10;
        }
        catch (IOException e) {
            this.log.info((Object)e.getLocalizedMessage());
            returnCode = 20;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnCode = 20;
        }
        if (returnCode != 0) {
            this.log.info((Object)"");
            this.exit(returnCode);
            return;
        }
    }

    private void displayHelp() {
        if (this.getCli().hasOption(DISPLAY_HELP)) {
            CLIManager.displayHelp();
            this.log.info((Object)"");
            this.exit(0);
            return;
        }
    }

    private void displayInfo() {
        if (this.getCli().hasOption(DISPLAY_INFO)) {
            CLIManager.displayInfo();
            this.log.info((Object)"");
            this.exit(0);
            return;
        }
    }

    private void displayVersion() {
        if (this.getCli().hasOption(DISPLAY_VERSION)) {
            this.printConsoleMavenHeader();
            this.exit(0);
            return;
        }
    }

    private int handleUnattainableGoalException(UnattainableGoalException e) {
        int returnCode = 60;
        System.out.println("");
        System.err.println("BUILD FAILED");
        String msg = null;
        String fileName = null;
        String elementName = null;
        int lineNumber = -1;
        int column = -1;
        Throwable rootCause = e.getRootCause();
        if (rootCause != null) {
            if (rootCause instanceof JellyException) {
                returnCode = 70;
                JellyException jellyEx = (JellyException)rootCause;
                fileName = jellyEx.getFileName();
                elementName = jellyEx.getElementName();
                lineNumber = jellyEx.getLineNumber();
                column = jellyEx.getColumnNumber();
                rootCause = jellyEx.getCause();
                if (rootCause == null) {
                    msg = jellyEx.getReason();
                } else {
                    if (this.getCli().hasOption(DISPLAY_STACKTRACE)) {
                        rootCause.printStackTrace();
                    }
                    if ((msg = rootCause.getLocalizedMessage()) == null) {
                        msg = rootCause.getClass().getName();
                    }
                }
                System.err.println("File...... " + fileName);
                System.err.println("Element... " + elementName);
                System.err.println("Line...... " + lineNumber);
                System.err.println("Column.... " + column);
            } else {
                rootCause.printStackTrace();
                msg = rootCause.getLocalizedMessage();
                if (msg == null) {
                    msg = rootCause.getClass().getName();
                }
            }
        } else {
            msg = e.getLocalizedMessage();
        }
        System.err.println(msg);
        if (this.getCli().hasOption(DEBUG)) {
            e.printStackTrace();
        }
        return returnCode;
    }

    private File find(String filename) {
        return this.find(new File(""), filename);
    }

    private File find(File start, String suffix) {
        if (start == null) {
            return null;
        }
        File dir = start.getAbsoluteFile();
        File file = new File(dir, suffix);
        return file.exists() ? file : this.find(dir.getParentFile(), suffix);
    }

    protected void printConsoleMavenHeader() {
        System.out.println(" __  __");
        System.out.println("|  \\/  |__ _Apache__ ___");
        System.out.println("| |\\/| / _` \\ V / -_) ' \\  ~ intelligent projects ~");
        System.out.println("|_|  |_\\__,_|\\_/\\___|_||_|  v. 1.0-rc2");
        System.out.println("");
    }

    protected void displayGoals() {
        int defaultWrapIndent;
        this.log.info((Object)"");
        String title = "Available [Plugins] / Goals";
        this.log.info((Object)title);
        this.log.info((Object)this.format("", title.length(), '`'));
        Set goals = this.mavenSession.getAllGoalNames();
        ArrayList list = new ArrayList(goals);
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                String g1 = (String)o1;
                String g2 = (String)o2;
                return g1.compareTo(g2);
            }
        };
        Collections.sort(list, comparator);
        int wrapIndent = defaultWrapIndent = 30;
        String msgPrefix = "";
        boolean hasDesc = false;
        boolean firstLine = true;
        boolean haveGoalsWithNoDescription = false;
        String lastPluginName = "";
        Iterator i = list.iterator();
        while (i.hasNext()) {
            boolean newPlugin;
            String goalName = (String)i.next();
            String goalDescription = this.mavenSession.getGoalDescription(goalName);
            StringTokenizer st = new StringTokenizer(goalName, ":");
            String pluginName = st.nextToken();
            boolean bl = newPlugin = !pluginName.equals(lastPluginName);
            if (goalDescription == null) {
                hasDesc = false;
            } else {
                boolean bl2 = hasDesc = (goalDescription = goalDescription.trim()).length() != 0;
            }
            if (newPlugin) {
                lastPluginName = pluginName;
                if (st.hasMoreTokens()) {
                    wrapIndent = defaultWrapIndent;
                    msgPrefix = "  " + st.nextToken() + " ";
                    if (msgPrefix.trim().length() == 0) {
                        msgPrefix = "  ( NO GOAL NAME ) ";
                    }
                    msgPrefix = this.format(msgPrefix, wrapIndent, '.') + " ";
                    ++wrapIndent;
                    msgPrefix = pluginName + "] ( NO DEFAULT GOAL )\n" + msgPrefix;
                } else {
                    msgPrefix = pluginName + "]";
                    if (hasDesc) {
                        msgPrefix = msgPrefix + " : ";
                        wrapIndent = msgPrefix.length();
                    }
                }
                if (firstLine) {
                    msgPrefix = "[" + msgPrefix;
                    firstLine = false;
                } else {
                    msgPrefix = "\n[" + msgPrefix;
                }
                if (hasDesc) {
                    System.out.println(msgPrefix + this.wrapConsoleMessage(goalDescription, wrapIndent, 80));
                    continue;
                }
                System.out.println(msgPrefix + " ( NO DESCRIPTION ) ");
                continue;
            }
            if (hasDesc) {
                wrapIndent = defaultWrapIndent;
                if (st.hasMoreTokens()) {
                    msgPrefix = "  " + st.nextToken() + " ";
                    if (msgPrefix.trim().length() == 0) {
                        msgPrefix = "  ( NO GOAL ) ";
                    }
                } else {
                    msgPrefix = "  ( NO GOAL ) ";
                }
                msgPrefix = this.format(msgPrefix, wrapIndent, '.') + " ";
                System.out.println(msgPrefix + this.wrapConsoleMessage(goalDescription, ++wrapIndent, 80));
                continue;
            }
            haveGoalsWithNoDescription = true;
        }
        if (haveGoalsWithNoDescription) {
            this.displayGoalsWithoutDescriptions(list);
        }
        this.log.info((Object)"");
    }

    private void displayGoalsWithoutDescriptions(List list) {
        System.out.println();
        System.out.println();
        System.out.println("Non documented goals : ");
        System.out.println();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String goalName = (String)i.next();
            String goalDescription = this.mavenSession.getGoalDescription(goalName);
            boolean hasDesc = false;
            if (goalDescription == null) {
                hasDesc = false;
            } else {
                boolean bl = hasDesc = goalDescription.trim().length() != 0;
            }
            if (hasDesc) continue;
            System.out.println("  " + goalName);
        }
    }

    protected String format(String orig, int width, char pad) {
        if (orig.length() >= width) {
            return orig;
        }
        StringBuffer buf = new StringBuffer().append(orig);
        int diff = width - orig.length();
        int i = 0;
        while (i < diff) {
            buf.append(pad);
            ++i;
        }
        return buf.toString();
    }

    protected String wrapConsoleMessage(String msg, int wrapIndent, int lineWidth) {
        int offset = lineWidth - wrapIndent;
        if (msg.length() <= offset) {
            return msg;
        }
        BreakIterator bIter = BreakIterator.getWordInstance();
        StringBuffer buf = new StringBuffer();
        String newLine = "\n";
        String pad = " ";
        int currentPos = 0;
        bIter.setText(msg);
        while (offset < bIter.getText().getEndIndex()) {
            if (Character.isWhitespace(bIter.getText().first())) {
                msg = msg.substring(1);
                bIter.setText(msg);
                continue;
            }
            currentPos = bIter.preceding(offset);
            buf.append(msg.substring(0, currentPos));
            buf.append(newLine);
            int i = 0;
            while (i != wrapIndent && i < lineWidth) {
                buf.append(pad);
                ++i;
            }
            msg = msg.substring(currentPos);
            bIter.setText(msg);
        }
        while (Character.isWhitespace(msg.charAt(0))) {
            msg = msg.substring(1);
        }
        buf.append(msg);
        return buf.toString();
    }

    protected static String formatTime(long ms) {
        long secs = ms / 1000L;
        long min = secs / 60L;
        secs %= 60L;
        if (min > 0L) {
            return min + " minutes " + secs + " seconds";
        }
        return secs + " seconds";
    }

    public static void main(String[] args) {
        Date start = new Date();
        App app = new App();
        app.doMain(args, start);
    }

    protected void exit(int status) {
        System.exit(status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

