/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.werkz;

import com.werken.werkz.NoActionDefinitionException;
import com.werken.werkz.NoSuchGoalException;
import com.werken.werkz.Session;
import com.werken.werkz.UnattainableGoalException;
import com.werken.werkz.WerkzProject;
import com.werken.werkz.jelly.JellySession;
import com.werken.werkz.jelly.WerkzTagSupport;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.GoalToJellyScriptHousingMapper;
import org.apache.maven.plugin.PluginManager;

public class MavenAttainGoalTag
extends WerkzTagSupport {
    private String name;
    private Session session;

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        if (this.session == null) {
            Session session = (Session)this.getContext().getVariable("maven.session.global");
            this.session = new JellySession(((MavenJellyContext)this.getContext()).getXMLOutput());
            Iterator i = session.getAttributes().keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.session.setAttribute(key, session.getAttribute(key));
            }
        }
        return this.session;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        WerkzProject project = this.getProject();
        if (project == null) {
            throw new JellyTagException("No Project available");
        }
        this.invokeBody(output);
        try {
            Set pluginSet;
            MavenJellyContext baseContext = (MavenJellyContext)((Object)this.getSession().getAttribute("maven.goalAttainmentContext"));
            GoalToJellyScriptHousingMapper mapper = (GoalToJellyScriptHousingMapper)this.getSession().getAttribute("maven.plugin.mapper");
            PluginManager pluginManager = (PluginManager)this.getSession().getAttribute("maven.plugin.manager");
            try {
                pluginSet = pluginManager.prepAttainGoal(this.getName(), baseContext, mapper);
            }
            catch (Exception e) {
                throw new JellyTagException((Throwable)e);
            }
            project.attainGoal(this.getName(), this.getSession());
            pluginManager.addDelayedPops(pluginSet);
        }
        catch (UnattainableGoalException e) {
            Throwable root = e.getRootCause();
            if (root != null) {
                if (root instanceof JellyTagException) {
                    throw (JellyTagException)root;
                }
                if (root instanceof UnattainableGoalException) {
                    throw new JellyTagException((Throwable)e);
                }
            }
            e.fillInStackTrace();
            throw new JellyTagException((Throwable)e);
        }
        catch (NoActionDefinitionException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (NoSuchGoalException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    public void invokeBody(XMLOutput output) throws JellyTagException {
        MavenJellyContext baseContext = (MavenJellyContext)((Object)this.getSession().getAttribute("maven.goalAttainmentContext"));
        this.getBody().run((JellyContext)baseContext, output);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public WerkzProject getProject() {
        return (WerkzProject)this.getContext().getVariable("org.apache.commons.jelly.werkz.Project");
    }
}

