/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.JellyScriptHousing;
import org.apache.maven.plugin.PluginDefinitionHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class PluginScriptParser
extends DefaultHandler {
    private final JellyScriptHousing jellyScriptHousing;
    private final PluginDefinitionHandler handler;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$plugin$PluginScriptParser == null ? (class$org$apache$maven$plugin$PluginScriptParser = PluginScriptParser.class$("org.apache.maven.plugin.PluginScriptParser")) : class$org$apache$maven$plugin$PluginScriptParser));
    private final Set dynaTagLibDecls = new HashSet();
    static /* synthetic */ Class class$org$apache$maven$plugin$PluginScriptParser;

    PluginScriptParser(PluginDefinitionHandler handler, JellyScriptHousing jellyScriptHousing) {
        this.handler = handler;
        this.jellyScriptHousing = jellyScriptHousing;
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (!(prefix.equals("") || uri.startsWith("jelly:") || uri.startsWith("dummy") || uri.equals(""))) {
            this.dynaTagLibDecls.add(uri);
            this.handler.addPluginDynaTagDep(this.jellyScriptHousing, uri);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching Taglib Uri --> " + uri));
            }
        }
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        if (rawName.equals("project")) {
            String defaultGoal = attributes.getValue("default");
            if (defaultGoal != null) {
                this.handler.setDefaultGoalName(defaultGoal);
            }
        } else if (rawName.equals("goal")) {
            String name = StringUtils.deleteWhitespace((String)attributes.getValue("name"));
            String prereqs = attributes.getValue("prereqs");
            String description = attributes.getValue("description");
            this.handler.addGoal(name, prereqs, description, this.jellyScriptHousing);
        } else if (rawName.equals("preGoal")) {
            String name = attributes.getValue("name");
            this.handler.addPreGoal(name, this.jellyScriptHousing);
        } else if (rawName.equals("postGoal")) {
            String name = attributes.getValue("name");
            this.handler.addPostGoal(name, this.jellyScriptHousing);
        } else if (!rawName.equals("attainGoal") && localName.equals("taglib") && uri.equals("jelly:define")) {
            String tagLibUri = attributes.getValue("uri");
            if (this.dynaTagLibDecls.contains(tagLibUri)) {
                this.handler.removePluginDynaTagDep(this.jellyScriptHousing, tagLibUri);
            }
            this.handler.addDynaTagLib(tagLibUri, this.jellyScriptHousing);
        }
    }

    public void warning(SAXParseException spe) {
        this.printParseError("Warning", spe);
    }

    public void error(SAXParseException spe) {
        this.printParseError("Error", spe);
    }

    public void fatalError(SAXParseException spe) {
        this.printParseError("Fatal Error", spe);
    }

    private final void printParseError(String type, SAXParseException spe) {
        System.err.println(type + " [line " + spe.getLineNumber() + ", row " + spe.getColumnNumber() + "]: " + spe.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

