/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenUtils;
import org.apache.maven.project.Dependency;
import org.apache.maven.repository.Artifact;
import org.apache.maven.util.MD5Sum;
import org.apache.maven.verifier.ChecksumVerificationException;
import org.apache.plexus.util.FileUtils;

public abstract class AbstractArtifact
implements Artifact {
    private Log log = LogFactory.getLog((Class)(class$org$apache$maven$repository$AbstractArtifact == null ? (class$org$apache$maven$repository$AbstractArtifact = AbstractArtifact.class$("org.apache.maven.repository.AbstractArtifact")) : class$org$apache$maven$repository$AbstractArtifact));
    protected static final String fs = File.separator;
    private Dependency dependency;
    private String path;
    static /* synthetic */ Class class$org$apache$maven$repository$AbstractArtifact;

    public AbstractArtifact(Dependency dependency) {
        this.dependency = dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setPath(String repositoryPath) {
        this.path = repositoryPath;
    }

    public String getPath() {
        if (this.path == null) {
            return this.generatePath();
        }
        return this.path;
    }

    public String generatePath() {
        return fs + this.getDependency().getArtifactDirectory() + fs + this.getDependency().getType() + "s" + fs + this.getDependency().getArtifact();
    }

    public String getUrlPath() {
        return "/" + this.getDependency().getArtifactDirectory() + "/" + this.getDependency().getType() + "s" + "/" + this.getDependency().getArtifact();
    }

    public String getChecksumUrl() {
        return "/" + this.getDependency().getArtifactDirectory() + "/" + this.getDependency().getType() + "s" + "/" + this.getDependency().getArtifact() + ".md5";
    }

    public String getName() {
        return this.getDependency().getArtifact();
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public boolean isSnapshot() {
        return this.getDependency().getArtifact().indexOf("SNAPSHOT") > 0;
    }

    public File getFile() {
        return new File(this.getPath());
    }

    public void verify() throws ChecksumVerificationException {
        File checksumFile = new File(this.getFile() + ".md5");
        if (!checksumFile.exists()) {
            return;
        }
        String actualChecksum = null;
        MD5Sum md5 = null;
        try {
            md5 = new MD5Sum();
            md5.setFile(this.getFile());
            md5.execute();
            actualChecksum = FileUtils.fileRead((String)checksumFile.getCanonicalPath());
            actualChecksum = actualChecksum.substring(0, actualChecksum.length() - 1);
        }
        catch (Exception e) {
            return;
        }
        this.log.debug((Object)("Actual checksum: '" + actualChecksum + "'"));
        this.log.debug((Object)("MD5 checksum: '" + md5.getChecksum() + "'"));
        if (!actualChecksum.equals(md5.getChecksum())) {
            throw new ChecksumVerificationException(MavenUtils.getMessage("checksum.verification.error", this.getPath()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

