/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.util.FileUtils;

public class Expand {
    private File dest;
    private File source;
    private boolean overwrite = true;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$util$Expand == null ? (class$org$apache$maven$util$Expand = Expand.class$("org.apache.maven.util.Expand")) : class$org$apache$maven$util$Expand));
    private FileUtils fileUtils;
    static /* synthetic */ Class class$org$apache$maven$util$Expand;

    public void execute() throws IOException {
        this.expandFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void expandFile() throws IOException {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(this.source));
            ZipEntry ze = null;
            this.setFileUtils(FileUtils.newFileUtils());
            while ((ze = zis.getNextEntry()) != null) {
                this.extractFile(zis, ze.getName(), new Date(ze.getTime()), ze.isDirectory());
            }
            log.debug((Object)"expand complete");
            Object var4_3 = null;
            if (zis == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (zis == null) throw throwable;
            try {
                zis.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            zis.close();
            return;
        }
        catch (IOException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractFile(InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws IOException {
        File f;
        block10: {
            f = this.fileUtils.resolveFile(this.dest, entryName);
            if (!this.overwrite && f.exists() && f.lastModified() >= entryDate.getTime()) {
                log.debug((Object)("Skipping " + f + " as it is up-to-date"));
                return;
            }
            log.debug((Object)("expanding " + entryName + " to " + f));
            File dirF = f.getParentFile();
            dirF.mkdirs();
            if (isDirectory) {
                f.mkdirs();
            } else {
                byte[] buffer = new byte[1024];
                int length = 0;
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(f);
                    while (true) {
                        if ((length = compressedInputStream.read(buffer)) < 0) {
                            fos.close();
                            fos = null;
                            Object var11_10 = null;
                            if (fos == null) break block10;
                            break;
                        }
                        fos.write(buffer, 0, length);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (fos == null) throw throwable;
                    try {
                        fos.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                fos.close();
            }
        }
        this.fileUtils.setFileLastModified(f, entryDate.getTime());
    }

    public void setDest(File d) {
        this.dest = d;
    }

    public void setSrc(File s) {
        this.source = s;
    }

    public void setOverwrite(boolean shouldOverwrite) {
        this.overwrite = shouldOverwrite;
    }

    public void setFileUtils(FileUtils utils) {
        this.fileUtils = utils;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

