/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.verifier;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.project.Project;
import org.apache.maven.repository.Artifact;
import org.apache.maven.util.HttpUtils;
import org.apache.maven.verifier.ChecksumVerificationException;
import org.apache.maven.verifier.LocalSettingsVerifier;
import org.apache.maven.verifier.RepoConfigException;
import org.apache.maven.verifier.UnsatisfiedDependencyException;

public class DependencyVerifier
extends AbstractMavenComponent {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$verifier$DependencyVerifier == null ? (class$org$apache$maven$verifier$DependencyVerifier = DependencyVerifier.class$("org.apache.maven.verifier.DependencyVerifier")) : class$org$apache$maven$verifier$DependencyVerifier));
    private boolean useTimestamp = true;
    private boolean ignoreErrors = true;
    private List failedDependencies = new ArrayList();
    private LocalSettingsVerifier localRepositoryVerifier;
    static /* synthetic */ Class class$org$apache$maven$verifier$DependencyVerifier;

    public DependencyVerifier(Project project) {
        super(project);
        this.localRepositoryVerifier = new LocalSettingsVerifier(project);
    }

    public void verify() throws RepoConfigException, UnsatisfiedDependencyException, ChecksumVerificationException {
        this.localRepositoryVerifier.verifyLocalRepository();
        this.satisfyDependencies();
    }

    private void clearFailedDependencies() {
        int i = 0;
        while (i < this.failedDependencies.size()) {
            this.failedDependencies.remove(i);
            ++i;
        }
    }

    private void satisfyDependencies() throws UnsatisfiedDependencyException {
        boolean remoteRepoEnabled = this.getProject().getContext().getRemoteRepositoryEnabled();
        boolean online = this.getProject().getContext().getOnline();
        if (!remoteRepoEnabled) {
            log.warn((Object)this.getMessage("remote.repository.disabled.warning"));
        }
        this.clearFailedDependencies();
        Iterator i = this.getProject().getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (!artifact.exists()) {
                this.failedDependencies.add(artifact);
                continue;
            }
            if (online && artifact.isSnapshot()) {
                this.failedDependencies.add(artifact);
                continue;
            }
            if (online || !artifact.isSnapshot()) continue;
            log.warn((Object)this.getMessage("offline.snapshot.warning", artifact.getName()));
        }
        if (!this.failedDependencies.isEmpty() && remoteRepoEnabled && online) {
            this.getDependencies();
        }
        if (!this.failedDependencies.isEmpty()) {
            throw new UnsatisfiedDependencyException(this.createUnsatisfiedDependenciesMessage());
        }
    }

    private String createUnsatisfiedDependenciesMessage() {
        StringBuffer message = new StringBuffer();
        if (this.failedDependencies.size() == 1) {
            message.append(this.getMessage("single.unsatisfied.dependency.error"));
        } else {
            message.append(this.getMessage("multiple.unsatisfied.dependency.error"));
        }
        message.append("\n\n");
        Iterator i = this.failedDependencies.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            message.append(artifact.getName());
            String url = artifact.getDependency().getUrl();
            if (StringUtils.isNotEmpty((String)url)) {
                message.append(" (").append("try downloading from ").append(url).append(")");
            } else {
                message.append(" (no download url specified)");
            }
            message.append("\n");
        }
        return message.toString();
    }

    private void getDependencies() {
        Iterator i = this.failedDependencies.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            File directory = artifact.getFile().getParentFile();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            log.info((Object)this.getMessage("download.message", artifact.getName()));
            if (this.getRemoteArtifact(artifact)) {
                i.remove();
                continue;
            }
            if (artifact.exists()) {
                log.debug((Object)("Artifact " + artifact.getUrlPath() + " doesn't exists in remote repository, but it exists locally"));
                i.remove();
                continue;
            }
            String warning = this.getMessage("failed.download.warning", artifact.getName());
            log.warn((Object)warning);
        }
    }

    private boolean getRemoteArtifact(Artifact artifact) {
        boolean artifactFound = false;
        Iterator i = this.getProject().getContext().getMavenRepoRemote().iterator();
        while (i.hasNext()) {
            String remoteRepo = (String)i.next();
            String url = remoteRepo + "/" + artifact.getUrlPath();
            if (!(url = StringUtils.replace((String)url, (String)"//", (String)"/")).startsWith("file")) {
                url = url.startsWith("https") ? StringUtils.replace((String)url, (String)"https:/", (String)"https://") : StringUtils.replace((String)url, (String)"http:/", (String)"http://");
            }
            try {
                log.debug((Object)("Getting URL: " + url));
                HttpUtils.getFile(url, artifact.getFile(), this.ignoreErrors, this.useTimestamp, this.getProject().getContext().getProxyHost(), this.getProject().getContext().getProxyPort(), this.getProject().getContext().getProxyUserName(), this.getProject().getContext().getProxyPassword(), true);
                artifactFound = true;
            }
            catch (FileNotFoundException e) {
                log.debug((Object)"File not found on one of the repos", (Throwable)e);
            }
            catch (Exception e) {
                log.warn((Object)("Error retrieving artifact from [" + url + "]: " + e));
            }
        }
        return artifactFound;
    }

    private void verifyDependencies() throws ChecksumVerificationException {
        Iterator i = this.getProject().getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            artifact.verify();
        }
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

