/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.deploy.deployers;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.deploy.DeployRequest;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.deploy.deployers.GenericSshDeployer;
import org.apache.maven.deploy.exceptions.AuthenticationException;
import org.apache.maven.deploy.exceptions.TransferFailedException;

public class SFtpDeployer
extends GenericSshDeployer {
    public static final String PROTOCOL = "sftp://";
    private static final String SFTP_CHANNEL = "sftp";
    private static final int S_IFDIR = 16384;
    private ChannelSftp channel = null;
    private Integer groupId = null;

    public void init(RepositoryInfo repoInfo) throws AuthenticationException {
        try {
            if (repoInfo.getGroup() != null) {
                this.groupId = Integer.getInteger(repoInfo.getGroup());
            }
        }
        catch (NumberFormatException e) {
            throw new AuthenticationException("SFTP deployer: remote group should be an integer");
        }
        super.init(repoInfo);
        this.channel = null;
        try {
            this.channel = (ChannelSftp)this.getSession().openChannel(SFTP_CHANNEL);
            this.channel.connect();
            this.channel.cd(repoInfo.getBasedir());
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
    }

    public void release() {
        this.channel.disconnect();
        super.release();
    }

    public void deploy(DeployRequest request) throws TransferFailedException {
        try {
            int i;
            String[] dirs = StringUtils.split((String)request.dirname(), (String)"/");
            for (i = 0; i < dirs.length; ++i) {
                try {
                    SftpATTRS attrs = this.channel.stat(dirs[i]);
                    if ((attrs.getPermissions() & 0x4000) == 0) {
                        throw new TransferFailedException("Incorrect remote path:" + request.getDestFile());
                    }
                    this.channel.cd(dirs[i]);
                    continue;
                }
                catch (Exception e) {
                    this.channel.mkdir(dirs[i]);
                    this.channel.cd(dirs[i]);
                }
            }
            if (this.getRepositoryInfo().isDebugOn()) {
                this.channel.put(request.getSrcFile(), request.filename(), (SftpProgressMonitor)new ProgressMonitor());
            } else {
                this.channel.put(request.getSrcFile(), request.filename());
            }
            if (this.groupId != null) {
                if (this.getRepositoryInfo().isDebugOn()) {
                    System.out.println("Changing group to: " + this.groupId);
                }
                this.channel.chgrp(this.groupId.intValue(), request.getDestFile());
                if (this.getRepositoryInfo().isDebugOn()) {
                    System.out.println("Group successfully changed");
                }
            }
            for (i = 0; i < dirs.length; ++i) {
                this.channel.cd("..");
            }
        }
        catch (SftpException e) {
            String msg = "Error occured while deploying to remote host:" + this.getRepositoryInfo().getHost() + ":" + e.getMessage();
            throw new TransferFailedException(msg, e);
        }
    }

    class ProgressMonitor
    implements SftpProgressMonitor {
        ProgressMonitor() {
        }

        public boolean count(long count) {
            System.out.print("#");
            return true;
        }

        public void end() {
            System.out.println();
        }

        public void init(int op, String src, String dest, long max) {
        }
    }
}

