/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ReleaseVersion {
    public static final void releaseVersion(File changesFile, String currentVersion, String version) throws DocumentException, FileNotFoundException, UnsupportedEncodingException, IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ReleaseVersion.releaseVersion(changesFile, currentVersion, version, dateFormat.format(new Date()));
    }

    public static final void releaseVersion(File changesFile, String currentVersion, String version, String date) throws DocumentException, FileNotFoundException, UnsupportedEncodingException, IOException {
        SAXReader r = new SAXReader();
        Document doc = r.read(changesFile);
        Element root = doc.getRootElement();
        Element releases = root.element("body");
        Iterator i = releases.elementIterator("release");
        while (i.hasNext()) {
            String text;
            Element e = (Element)i.next();
            Attribute v = e.attribute("version");
            if (v == null || !(text = v.getText()).equals(currentVersion) && !text.equals(version)) continue;
            v.setText(version);
            Attribute d = e.attribute("date");
            if (d == null) {
                e.addAttribute("date", date);
                continue;
            }
            d.setText(date);
        }
        FileUtils.copyFile((File)changesFile, (File)new File(changesFile + ".backup"));
        FileOutputStream os = new FileOutputStream(changesFile);
        OutputFormat format = new OutputFormat();
        format.setIndentSize(2);
        format.setNewlines(true);
        format.setTrimText(true);
        XMLWriter writer = new XMLWriter(format);
        writer.setOutputStream((OutputStream)os);
        writer.write(doc);
    }
}

