<?xml version="1.0"?>

<!--
    Author:     Berin Loritsch (bloritsch@infoplanning.com)
    Author:     Peter Donald  (donaldp@apache.org)
    Author:     dIon Gillard (trongus@yahoo.com)
    Version:    $Id: docbook2document.xsl,v 1.2 2003/05/19 00:13:10 dion Exp $
    FIXME:      - Doesn't handle attributes of informaltable and other docbook
                  elements
                - currently doesn't process all docbook elements
  -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <!-- used for cross ref links (xref) -->
  <xsl:key name="id" match="*" use="@id"/>

  <xsl:template match="/">
    <xsl:comment>This document generated by docbook2document.xsl</xsl:comment>
    <xsl:apply-templates />
  </xsl:template>
    
  <!-- 
      top level components create document, properties element and start body
    -->
  <xsl:template match="article">
    <document>
      <properties>
        <xsl:apply-templates select="title"/>
        <xsl:apply-templates select="author"/>
      </properties>

      <body>
        <xsl:apply-templates />

        <xsl:apply-templates select="//footnote" mode="base"/>
      </body>
    </document>
  </xsl:template>

  <xsl:template match="title">
        <title>
          <xsl:value-of select="title"/>
          <xsl:if test="../subtitle">
            (<xsl:value-of select="../subtitle"/>)
          </xsl:if>
          <!-- ignoring titleabbrev -->
        </title>
  </xsl:template>

  <!-- author block -->
  <xsl:template match="author">
    <author email="{authorblurb/para/email}">
      <xsl:if test="honorific"><xsl:value-of select="honorific"/>. </xsl:if>
      <xsl:if test="firstname">
        <xsl:value-of select="firstname"/>
        <xsl:text> </xsl:text>
      </xsl:if>
      <xsl:value-of select="surname"/>
      <xsl:apply-templates />
    </author>
  </xsl:template>

  <xsl:template match="affiliation">
    <xsl:if test="jobtitle">
      (Job title: <xsl:value-of select="jobtitle"/>
    </xsl:if>
    <xsl:if test="orgname">
      , <i>Organisation:</i> <xsl:value-of select="orgname"/>)
    </xsl:if>
  </xsl:template>

  <xsl:template match="authorblurb">
    <xsl:text>Bio</xsl:text>
    <ul>
      <xsl:apply-templates/>
    </ul>
  </xsl:template>

  <xsl:template match="honorific|firstname|surname|orgdiv|orgname|shortaffil|jobtitle"/>

  <!-- revision history -->
  <xsl:template match="revhistory">
    <section name="Revision History">
      <xsl:variable name="unique-revisions" 
        select="revision[not(revnumber=preceding-sibling::revision/revnumber)]/revnumber"/>

      <xsl:variable name="base" select="."/>

      <xsl:for-each select="$unique-revisions">
        <p>Revision <xsl:value-of select="."/> 
          (<xsl:value-of select="$base/revision[revnumber=current()]/date"/>)
        </p>
        <ul>
          <xsl:apply-templates select="$base/revision[revnumber=current()]"/>
        </ul>
      </xsl:for-each>
    </section>
  </xsl:template>

  <xsl:template match="revision">
    <li>
      <xsl:choose>
        <xsl:when test="@revisionflag='added'">
          <img align="absmiddle" alt="added" border="0" src="images/add.jpg"/>
        </xsl:when>
        <xsl:when test="@revisionflag='changed'">
          <img align="absmiddle" alt="changed" border="0" src="images/update.jpg"/>
        </xsl:when>
        <xsl:when test="@revisionflag='deleted'">
          <img align="absmiddle" alt="deleted" border="0" src="images/remove.jpg"/>
        </xsl:when>
        <xsl:when test="@revisionflag='off'">
          <img align="absmiddle" alt="off" border="0" src="images/fix.jpg"/>
        </xsl:when>
        <xsl:otherwise>
          <img align="absmiddle" alt="changed" border="0" src="images/update.jpg"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="revremark"/>
      <xsl:text> (</xsl:text><xsl:value-of select="authorinitials"/><xsl:text>)</xsl:text>
    </li>
  </xsl:template>

  <xsl:template match="revnumber|revremark|authorinitials|date"/>

  <xsl:template match="section">
    <xsl:call-template name="section-common">
      <xsl:with-param name="level" select="count(ancestor::section)+1"/>
    </xsl:call-template>
  </xsl:template>

  <!-- sections - and nested -->
  <xsl:template name="section-common">
    <xsl:param name="level"/>

    <xsl:choose>
      <xsl:when test="number($level)=1">
        <xsl:if test="@id"><a name="{@id}"> </a></xsl:if>
        <section name="{title}">
          <xsl:apply-templates/>
        </section>
      </xsl:when>
      <xsl:when test="number($level)=2">
        <xsl:if test="@id"><a name="{@id}"> </a></xsl:if>
        <subsection name="{title}">
          <xsl:apply-templates/>
        </subsection>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="@id"><a name="{@id}"> </a></xsl:if>
        <p><a name="{@name}"><strong><xsl:value-of select="title"/></strong></a><br />
          <xsl:apply-templates/>
        </p>    
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
    
  <!-- paragraphs/textual elements -->
  <xsl:template match="para">
    <p><xsl:apply-templates/></p>
  </xsl:template>

  <xsl:template match="emphasis"><em><xsl:apply-templates/></em></xsl:template>
    
  <xsl:template match="example">
    <p><pre><xsl:apply-templates/></pre></p>
  </xsl:template>

  <!-- book details --> 
  <xsl:template match="bookinfo">
    <b><xsl:value-of select="edition"/></b><xsl:text> </xsl:text>
    <i>pub. <xsl:value-of select="pubdate"/></i>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="dedication">
    <b>Dedication</b>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="edition|pubdate|year|holder"/>

  <xsl:template match="copyright">
    <p>Copyright &#x00A9;<xsl:value-of select="year"/> by 
      <xsl:value-of select="holder"/>.<br/>
      <i>All rights reserved.</i>
    </p>
  </xsl:template>

  <xsl:template match="legalnotice">
    <p>Legal Notice</p>
    <xsl:apply-templates/>
  </xsl:template>

  <!-- lists etc -->
  <xsl:template match="programlisting">
    <source><xsl:apply-templates/></source>
  </xsl:template>

  <xsl:template match="orderedlist"><ol><xsl:apply-templates/></ol></xsl:template>

  <xsl:template match="listitem|member"><li><xsl:apply-templates/></li></xsl:template>

  <xsl:template match="itemizedlist|simplelist"><ul><xsl:apply-templates/></ul></xsl:template>
    
  <xsl:template match="classname|function|parameter"><code><xsl:apply-templates/><xsl:if test="name(.)='function'"><xsl:text>()</xsl:text></xsl:if></code></xsl:template>

  <xsl:template match="blockquote">
    <xsl:if test="title">
      <blockquote><xsl:value-of select="title"/><br/>
        <xsl:apply-templates/>
      </blockquote>
    </xsl:if>
    <p></p>
  </xsl:template>

  <xsl:template match="warning">
    <xsl:if test="title">
      <p><em><xsl:value-of select="title"/></em></p>
    </xsl:if>
    <p><xsl:apply-templates/></p>
  </xsl:template>

  <!-- links -->
  <xsl:template match="ulink"><a href="{@url}"><xsl:apply-templates/></a></xsl:template>
  <xsl:template match="xref">
    <!--
        make a link to the linkend specified, prefixing with a # since it's
        internal to the generated html. The text of the link should be either
        a) element pointed to by linkend's xreflabel or
        b) endterm content
     -->
    <xsl:variable name="link-targets" select="key('id',@linkend)"/>
    <xsl:variable name="link-target" select="$link-targets[1]"/>

    <a href="#{@linkend}">
      <!-- xreflabel of target goes here-->
      <xsl:choose>
        <xsl:when test="$link-target/@xreflabel">
          <xsl:value-of select="$link-target/@xreflabel"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="endterm-targets" select="key('id',@endterm)"/>
          <xsl:variable name="endterm-target" select="$endterm-targets[1]"/>
          <xsl:apply-templates select="$endterm-target"/>
        </xsl:otherwise>
      </xsl:choose>
    </a>
  </xsl:template>

  <!-- tables, footnotes etc -->
  <xsl:template match="footnote">
    <sup><a href="#{generate-id(.)}"><xsl:value-of select="generate-id(.)"/></a>
    </sup>
  </xsl:template>

  <xsl:template match="footnote" mode="base">
    <a name="{generate-id(.)}"/><xsl:value-of select="generate-id(.)"/><xsl:text>) </xsl:text><i><xsl:value-of select="."/></i>
  </xsl:template>

  <xsl:template match="figure">
    <p>Figure: <xsl:value-of select="title"/></p>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="graphic">
    <img border="0" alt="{@srccredit}" src="{@fileref}"/>
    <xsl:if test="@srccredit">
      <ul><li><xsl:value-of select="@srccredit"/></li></ul>
    </xsl:if>
  </xsl:template>

  <xsl:template match="table"><table><xsl:apply-templates/></table></xsl:template>

  <!-- FIXME: support attributes of informal table here -->
  <xsl:template match="informaltable">
    <table><xsl:apply-templates/></table>
  </xsl:template>

  <xsl:template match="tgroup">
    <xsl:apply-templates select="thead|tbody|tfoot"/>
  </xsl:template>

  <xsl:template match="thead">
    <xsl:apply-templates select="row" mode="head"/>
  </xsl:template>

  <xsl:template match="row" mode="head">
    <tr><xsl:apply-templates select="entry" mode="head"/></tr>
  </xsl:template>

  <xsl:template match="row">
    <tr><xsl:apply-templates/></tr>
  </xsl:template>

  <xsl:template match="tbody|tfoot">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="entry" mode="head">
    <th><xsl:apply-templates/></th>
  </xsl:template>
  
  <xsl:template match="entry">
    <td><xsl:apply-templates/></td>
  </xsl:template>

  <xsl:template match="firstterm">
    <i><xsl:apply-templates/></i>
  </xsl:template>
  
  <xsl:template match="remark">
    <p><b>Note:</b> <xsl:apply-templates/></p>
  </xsl:template>
  
  <xsl:template match="sgmltag">
    <code><xsl:apply-templates/></code>
  </xsl:template>
  
  <xsl:template match="trademark"><xsl:apply-templates/><sup>TM</sup></xsl:template>

  <xsl:template match="node()|@*" priority="-1">
    <xsl:copy>
      <xsl:apply-templates select="node()|@*"/>
    </xsl:copy>
  </xsl:template>
  
</xsl:stylesheet>

