// File.h
#ifndef __WGC_FILE__
#define __WGC_FILE__

#include "wgc.h"


_WGC_BEGIN                              // namespace wgc {

class File
{
public:
	File(HANDLE hFile);
	File(
		LPCTSTR               lpszFileName,
		const DWORD           dwDesiredAccess       = GENERIC_READ | GENERIC_WRITE,
		const DWORD           dwShareMode           = FILE_SHARE_READ,
		LPSECURITY_ATTRIBUTES lpSecurityAttributes  = NULL,
		const DWORD           dwCreationDisposition = CREATE_ALWAYS,
		const DWORD           dwFlagsAndAttributes  = FILE_ATTRIBUTE_NORMAL,
		HANDLE                hTemplateFile         = NULL);
	~File(void);

	// ړ
	DWORD Seek(const DWORD dwMoveMethod, const LONG lPositionLo, LPLONG lpPositionHi = NULL);
	void  SeekToBegin(void);
	void  SeekToEnd  (void);

	// ǂݍ/
	DWORD Read (LPVOID  lpBuffer, const DWORD nNumber);
	DWORD Write(LPCVOID lpBuffer, const DWORD nNumber);
	void  Flush(void);

	// 
	DWORD GetSize(LPDWORD lpFileSizeHigh = NULL) const;
	void  GetTime(LPFILETIME lpCreationTime = NULL, LPFILETIME lpLastAccessTime = NULL, LPFILETIME lpLastWriteTime = NULL) const;

	static DWORD GetAttributes(LPCTSTR lpszPathName);
	static BOOL  IsReadOnly   (LPCTSTR lpszPathName);
	static BOOL  IsHidden     (LPCTSTR lpszPathName);
	static BOOL  IsDirectory  (LPCTSTR lpszPathName);

	operator HANDLE(void) const;

private:
	HANDLE m_hFile;
	BOOL   m_bOwner;
};


// t@C}bsOIuWFNg
class mapping_object
{
public:
	// t@C}bsOf[^
	template<typename _Ty>
	class mapping_data
	{
	public:
		mapping_data(
			mapping_object &rMappingObject,
			const DWORD dwDesiredAccess      = FILE_MAP_READ,
			const DWORD dwFileOffsetHigh     = 0,
			const DWORD dwFileOffsetLow      = 0,
			const DWORD dwNumberOfBytesToMap = 0) : m_lpData(NULL)
		{
			LPVOID lpData = ::MapViewOfFile(
				rMappingObject,
				dwDesiredAccess,
				dwFileOffsetHigh,
				dwFileOffsetLow,
				dwNumberOfBytesToMap);

			if(lpData == NULL)
			{
				wgfThrowLastError();
			}
			m_lpData = reinterpret_cast<_Ty *>(lpData);
		}

		~mapping_data(void)
		{
			::UnmapViewOfFile(m_lpData);
			m_lpData = NULL;
		}

		_Ty *GetData(void) { return m_lpData; }
		const _Ty *GetData(void) const { return m_lpData; }

	private:
		_Ty *m_lpData;
	};

	mapping_object(
		File                  &rFile,
		LPSECURITY_ATTRIBUTES lpFileMappingAttributes = NULL,
		const DWORD           flProtect = PAGE_READONLY,
		const DWORD           dwMaximumSizeHigh = 0,
		const DWORD           dwMaximumSizeLow  = 0,
		LPCTSTR               lpName = NULL);

	~mapping_object(void);

	operator HANDLE(void) const;

private:
	HANDLE m_hMap;
};

_WGC_END                                // }

#endif // __WGC_FILE__
