// SpinButtonCtrl.cpp cCve[Vt@C
#include "SpinButtonCtrl.h"


_WGC_BEGIN                              // namespace wgc {

////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
SpinButtonCtrl::SpinButtonCtrl(void)
{
}

// fXgN^
SpinButtonCtrl::~SpinButtonCtrl(void)
{
}


////////////////////////////////////////////////////////////////////////////////
// ANZ[V

UINT SpinButtonCtrl::GetAccel(const int nAccel, UDACCEL *pAccel) const
{
	const LRESULT lResult = SendMessage(
		UDM_GETACCEL,
		static_cast     <WPARAM>(nAccel),
		reinterpret_cast<LPARAM>(pAccel));
	return static_cast<UINT>(lResult);
}

BOOL SpinButtonCtrl::SetAccel(const int nAccel, UDACCEL *pAccel)
{
	const LRESULT lResult =  SendMessage(
		UDM_SETACCEL,
		static_cast     <WPARAM>(nAccel),
		reinterpret_cast<LPARAM>(pAccel));
	return static_cast<BOOL>(lResult);
}


////////////////////////////////////////////////////////////////////////////////
// l

UINT SpinButtonCtrl::GetBase(void) const
{
	const LRESULT lResult = SendMessage(UDM_GETBASE);
	return static_cast<UINT>(lResult);
}

int SpinButtonCtrl::SetBase(const int nBase)
{
	const LRESULT lResult = SendMessage(UDM_SETBASE, (WPARAM)nBase);
	return static_cast<int>(lResult);
}


////////////////////////////////////////////////////////////////////////////////
// ofBEChE

HWND SpinButtonCtrl::GetBuddy(void) const
{
	LRESULT lResult = SendMessage(UDM_GETBUDDY);
	return reinterpret_cast<HWND>(lResult);
}

HWND SpinButtonCtrl::SetBuddy(HWND hWndBuddy)
{
	LRESULT lResult = SendMessage(UDM_SETBUDDY, reinterpret_cast<WPARAM>(hWndBuddy));
	return reinterpret_cast<HWND>(lResult);
}


////////////////////////////////////////////////////////////////////////////////
// ʒu

int SpinButtonCtrl::GetPos(void) const
{
	const LRESULT lResult = SendMessage(UDM_GETPOS);
	return static_cast<int>(lResult);
}

int SpinButtonCtrl::SetPos(const int nPos)
{
	const LRESULT lResult = SendMessage(UDM_SETPOS, 0, (LPARAM)MAKELONG((short)nPos, 0));
	return static_cast<int>(lResult);
}


////////////////////////////////////////////////////////////////////////////////
// ͈

DWORD SpinButtonCtrl::GetRange(void) const
{
	const LRESULT lResult = SendMessage(UDM_GETRANGE);
	return static_cast<DWORD>(lResult);
}

void SpinButtonCtrl::GetRange(int &lower, int &upper) const
{
	const DWORD dwRange = GetRange();

	lower = HIWORD(dwRange);
	upper = LOWORD(dwRange);
}

void SpinButtonCtrl::GetRange32(int &lower, int &upper) const
{
	SendMessage(UDM_GETRANGE32, (WPARAM)&lower, (LPARAM)&upper);
}

void SpinButtonCtrl::SetRange(const int nLower, const int nUpper)
{
	SendMessage(UDM_SETRANGE, 0, (LPARAM)MAKELONG((short)nUpper, (short)nLower));
}

void SpinButtonCtrl::SetRange32(const int nLower, const int nUpper)
{
	SendMessage(UDM_SETRANGE32, nLower, nUpper);
}

_WGC_END                                // }
