// CommandInterface.cpp cCve[Vt@C
#include "CommandInterface.h"


////////////////////////////////////////////////////////////////////////////////
// j[pR}hC^[tF[X
command_interface_menu::command_interface_menu(HMENU hMenu)
{
	m_hMenu = hMenu;
}

void command_interface_menu::check(const UINT uCommand, const BOOL bCheck /* = TRUE */) const
{
	::CheckMenuItem(m_hMenu, uCommand, bCheck ? MF_CHECKED : MF_UNCHECKED);
}

void command_interface_menu::enable(const UINT uCommand, const BOOL bEnable /* = TRUE */) const
{
	::EnableMenuItem(m_hMenu, uCommand, bEnable ? MF_ENABLED : MF_GRAYED);
}

void command_interface_menu::radio(const UINT uCommandFirst, const UINT uCommandLast, const UINT uCommandRadio) const
{
	::CheckMenuRadioItem(m_hMenu, uCommandFirst, uCommandLast, uCommandRadio, MF_BYCOMMAND);
}


////////////////////////////////////////////////////////////////////////////////
// c[o[pR}hC^[tF[X
#include <commctrl.h>

command_interface_toolbar::command_interface_toolbar(HWND hWndToolBar)
{
	m_hWndToolBar = hWndToolBar;
}

void command_interface_toolbar::check(const UINT uCommand, const BOOL bCheck /* = TRUE */) const
{
	::SendMessage(
		m_hWndToolBar,
		TB_CHECKBUTTON,
		uCommand,
		MAKELONG(bCheck, 0));
}

void command_interface_toolbar::enable(const UINT uCommand, const BOOL bEnable /* = TRUE */) const
{
	::SendMessage(
		m_hWndToolBar,
		TB_ENABLEBUTTON,
		uCommand,
		MAKELONG(bEnable, 0));
}

void command_interface_toolbar::radio(const UINT uCommandFirst, const UINT uCommandLast, const UINT uCommandRadio) const
{
	for(UINT uCommand = uCommandFirst; uCommand <= uCommandLast; uCommand++)
	{
		check(uCommand, (uCommand == uCommandRadio));
	}
}
