// DialogPropertyPage.cpp cCve[Vt@C
#include "DialogPropertyPage.h"


_WGC_BEGIN                              // namespace wgc {


////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
DialogPropertyPage::DialogPropertyPage(HINSTANCE hResource, LPCTSTR lpTemplate, HWND hWndParent /* = NULL */)
	: Dialog(hResource, lpTemplate, hWndParent)
{
	m_psp.dwSize      = sizeof(PROPSHEETPAGE);
	m_psp.dwFlags     = PSP_USECALLBACK;
	m_psp.hInstance   = hResource;
	m_psp.pfnDlgProc  = reinterpret_cast<DLGPROC>(_WindowProcBase);
	m_psp.pfnCallback = _PropSheetPageProcBase;
	m_psp.lParam      = reinterpret_cast<LPARAM>(this);
	m_psp.pszTemplate = lpTemplate;
}

// fXgN^
DialogPropertyPage::~DialogPropertyPage(void)
{
}


void DialogPropertyPage::GetPropPage(PROPSHEETPAGE &psp) const
{
	psp = m_psp;
}


// ʒmbZ[W
BOOL DialogPropertyPage::OnNotify(const int nIdCtrl, LPNMHDR lpNmHeader)
{
	switch(lpNmHeader->code)
	{
	case PSN_APPLY:
		OnNotify_Apply();
		return TRUE;
	}
	return Dialog::OnNotify(nIdCtrl, lpNmHeader);
}

// R}h
BOOL DialogPropertyPage::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	// eEChE֕ύXʒm𑗂
	PropSheet_Changed(GetParent(), m_hWnd);
	return Dialog::OnCommand(wNotifyCode, wID, hWndCtrl);
}

void DialogPropertyPage::OnNotify_Apply(void)
{
	UpdateData();
}


UINT CALLBACK DialogPropertyPage::_PropSheetPageProcBase(HWND /* hWnd */, UINT uMsg, LPPROPSHEETPAGE lpPSP)
{
	DialogPropertyPage *pThis = NULL;

	switch(uMsg)
	{
	case PSPCB_CREATE:
		pThis = reinterpret_cast<DialogPropertyPage *>(lpPSP->lParam);
		_SetHookTarget(pThis);
		return TRUE;

	case PSPCB_RELEASE:
		return 0;
	}
	return 0;
}

_WGC_END                                // }
