// Customize_Other.cpp cCve[Vt@C
#include "Customize_Other.h"


////////////////////////////////////////////////////////////////////////////////
// RXgN^
DialogCustomize_Other::DialogCustomize_Other(MAINFRAME_PROPERTY::OTHER &rProperty)
	: DialogPropertyPage(GetResourceHandle(), MAKEINTRESOURCE(IDD), NULL),
	m_rProperty(rProperty)
{
}

// fXgN^
DialogCustomize_Other::~DialogCustomize_Other(void)
{
}


void DialogCustomize_Other::AssociateDialogControls(void)
{
	m_ctrlBackupPrefix.SubclassDlgItem(IDC_CUSTOMIZE_OTHER_BACKUPPREFIX, this);
}

void DialogCustomize_Other::UpdateData(const BOOL bUpdate /* = TRUE */)
{
	// _CAOIuWFNg
	if(bUpdate)
	{
		m_rProperty.flags.elements.bBackupWhenCrushed = (IsDlgButtonChecked(IDC_CUSTOMIZE_OTHER_BACKUPWHENCRUSHED) == BST_CHECKED);
		m_ctrlBackupPrefix.GetWindowText(m_rProperty.strBackupPrefix);
	}
	// IuWFNg_CAO
	else
	{
		CheckDlgButton(IDC_CUSTOMIZE_OTHER_BACKUPWHENCRUSHED, m_rProperty.flags.elements.bBackupWhenCrushed);
		m_ctrlBackupPrefix.SetWindowText(m_rProperty.strBackupPrefix);
	}
}


// _CAO
BOOL DialogCustomize_Other::OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam)
{
	DialogPropertyPage::OnInitDialog(hWndFocus, dwInitParam);

	// e평
	InitToolTips();                         // c[`bv

	UpdateData(FALSE);

	OnCommand_BackupWhenCrushed();
	return FALSE;
}

// R}h
BOOL DialogCustomize_Other::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	BOOL bResult = DialogPropertyPage::OnCommand(wNotifyCode, wID, hWndCtrl);
	switch(wID)
	{
	case IDC_CUSTOMIZE_OTHER_BACKUPWHENCRUSHED:
		OnCommand_BackupWhenCrushed();
		bResult = FALSE;
		break;
	}
	return bResult;
}


////////////////////////////////////////////////////////////
// R}hnh

void DialogCustomize_Other::OnCommand_BackupWhenCrushed(void)
{
	UpdateData();

	m_ctrlBackupPrefix.EnableWindow(m_rProperty.flags.elements.bBackupWhenCrushed);
}


////////////////////////////////////////////////////////////
// 

// c[`bv
void DialogCustomize_Other::InitToolTips(void)
{
	const UINT array[] =
	{
		IDC_CUSTOMIZE_OTHER_BACKUPWHENCRUSHED,
		IDC_CUSTOMIZE_OTHER_BACKUPPREFIX,
	};
	SetToolTips(array, countof(array));
}
