// NotifyBackup.h cobNAbvʒm_CAO
#ifndef __DIALOG_NOTIFYBACKUP__
#define __DIALOG_NOTIFYBACKUP__

#include "../WinMain.h"
#include "../Station.h"
#include "../component/wgc/ListBoxCtrl.h"


class DialogNotifyBackup : public wgc::Dialog
{
public:
	explicit DialogNotifyBackup(HWND hWndParent, BACKUP_LIST_T &backup_list);
	~DialogNotifyBackup(void);

	UINT GetOpenFileCount(void) const;

protected:
	enum { IDD = IDD_NOTIFYBACKUP };

	wgc::ListBoxCtrl m_ctrlFileList; 

	UINT m_uOpenFileCount;
	const BACKUP_LIST_T &m_backup_list;

	void AssociateDialogControls(void);
	void UpdateData(const BOOL bUpdate = TRUE);

	void Open(const UINT index);

	BOOL OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam);
	BOOL OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl);

	void OnCommand_FileList(const WORD wNotifyCode);
	void OnCommand_FileList_SelChange(void);
	void OnCommand_Open(void);
	void OnCommand_OpenAll(void);
};

#endif // __DIALOG_NOTIFYBACKUP__
