// EditDoc.h cGfBbgR|[lgihLgj
#ifndef __EDIT_DOC__
#define __EDIT_DOC__

#include "Edit.h"
#include "component/sgc/edit_manager.h" // sgc::edit_manager

#include <list>                         // std::list<>


// sgc::edit_managerōsobt@ɉA
// r[⃁Ct[Ƃ̘AgȂǁAWindowsˑs
class EditDoc
{
public:
	////////////////////////////////////////////////////////////
	// ^̒`
	typedef sgc::edit_manager::const_iterator_t const_iterator_t;
	typedef sgc::edit_manager::linenumber_t     linenumber_t;
	typedef sgc::position_t                     position_t;

	typedef std::list<EditView *>      viewlist_t;
	typedef viewlist_t::iterator       viewlist_iterator_t;
	typedef viewlist_t::const_iterator viewlist_const_iterator_t;


	////////////////////////////////////////////////////////////
	// RXgNV
	EditDoc (wgc::Window *pMainFrame, const EDITVIEW_PROPERTY &rProperty, HCURSOR hCursorMargin = NULL);
	~EditDoc(void);

	BOOL CreateView(
		const BOOL bSetFocus,
		const DWORD dwStyle, const DWORD dwExStyle,
		const UINT nID,
		wgc::Window *pParent = NULL,
		HINSTANCE hInstance  = NULL,
		const int x = CW_USEDEFAULT,
		const int y = CW_USEDEFAULT,
		const int nWidth  = CW_USEDEFAULT,
		const int nHeight = CW_USEDEFAULT);
	void DestroyView(const UINT nIndex);

	void ResizeWindow(const int nID, const RECT &rRect);
	void SetFocusTo(const int nID = -1);

	void SetViewProperty(const EDITVIEW_PROPERTY &rProperty, const KEYWORD_INFO &rKeyword);
	void InvalidateAllViews(void);

	////////////////////////////////////////////////////////////
	// 
	INT_PTR GetNowLine(void) const;
	void    JumpToLine(const INT_PTR nLineNumber);

	void DragBegin(void);
	void DragEnd  (void);
	BOOL IsDropSource(void) const;

	////////////////////////////////////////////////////////////
	// 
	SIZE_T GetLineCount(void) const;
	BOOL IsBegin(void) const;
	BOOL IsEnd  (void) const;

	////////////////////////////////////////////////////////////
	// W
	position_t SetCaretPosition(void) const;
	void       SetCaretPosition(const position_t &position);

	////////////////////////////////////////////////////////////
	// Ce[^
	const_iterator_t GetIterator     (const linenumber_t linenumber) const;
	const_iterator_t GetIteratorBegin(void) const;
	const_iterator_t GetIteratorEnd  (void) const;
	const_iterator_t GetIteratorNow  (void) const;

	////////////////////////////////////////////////////////////
	// ̐ݒ/擾
	BOOL SetReadOnly   (const BOOL bReadOnly = TRUE);
	BOOL ToggleReadOnly(void);
	BOOL IsReadOnly    (void) const;
	BOOL SetOverwrite   (const BOOL bOverwrite = TRUE);
	BOOL ToggleOverwrite(void);
	BOOL IsOverwrite    (void) const;
	BOOL SetModify (const BOOL bModify = TRUE);
	BOOL IsModified(void) const;

	////////////////////////////////////////////////////////////
	// Nbv{[h֘A
	void Cut(void);
	void Copy(void);
	void Clear(void);
	void Paste(void);
	BOOL CanPaste(const UINT uFormat = 0) const;

	////////////////////////////////////////////////////////////
	// ҏW
	BOOL    Undo(void);
	BOOL    Redo(void);
	BOOL    CanUndo(void) const;
	BOOL    CanRedo(void) const;
	INT_PTR SetUndoLimit(const INT_PTR nLimit = -1);
	void    EmptyUndoBuffer(void);

	BOOL SetText       (LPCWSTR lpText, const SIZE_T lSize);
	BOOL InsertText    (LPCWSTR lpText, const SIZE_T lSize);
	BOOL InsertLinefeed(void);
	BOOL SendString    (const wgc::wstring_t &wstr);
	BOOL DeleteChar    (const BOOL bLeft = TRUE);

	BOOL IsSelected(void) const;
	void GetSelectedText (wgc::tstring_t &tstr) const;
	void GetSelectedTextA(wgc:: string_t & str) const;
	void GetSelectedTextW(wgc::wstring_t &wstr) const;

	////////////////////////////////////////////////////////////
	// ̑
	void Reconvert(void);

private:
	wgc::Window       *m_pMainFrame;           // Ct[
	EDITVIEW_PROPERTY  m_property;             // r[vpeB
	KEYWORD_INFO       m_keyword;

	sgc::edit_manager m_manager;               // GfBbg}l[W

	// \[Xnh
	HFONT   m_hFont;
	HCURSOR m_hCursorMargin;

	// r[
	viewlist_t m_listView;
	EditView  *m_pActiveView;

	// OLEhbOhbv
	BOOL m_bDropSource;

	// JbgW
	position_t GetXY(void) const;
	void       SetXY(const position_t &position);
	INT_PTR    GetX (void) const;
	INT_PTR    GetY (void) const;
	INT_PTR    SetX (const INT_PTR x);
	INT_PTR    SetY (const INT_PTR y);
	INT_PTR    SetXRelative(const INT_PTR dx);
	INT_PTR    SetYRelative(const INT_PTR dy);

	EditView *GetViewFromID(const int nID) const;

	void PostModify(const linenumber_t lineModify, const BOOL bUpdateLineNumber = FALSE);

	LRESULT SendNotifyCommandToMainFrame(const WORD wNotify);

	static HFONT CreateInfoFont(const FONT_INFO &info);
	static BOOL  SetClipboard(const CLIPFORMAT cfFormat, LPCVOID lpData, const SIZE_T dwSize);

private:
	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(EditDoc)

	friend class EditView;
};

#endif // __EDIT_DOC__
