// WinMain.h
#ifndef __WINMAIN__
#define __WINMAIN__

#include "Common.h"
#include "FrameThread.h"


// ֐̃vg^Cv錾
void RegisterMainFrameHandle(HWND hWnd);

int AppMessageBox      (HWND hWnd, const wgc::tstring_t &text, const UINT uType = MB_OK | MB_ICONEXCLAMATION);
int AppMessageBox      (HWND hWnd, const UINT     nIDResource, const UINT uType = MB_OK | MB_ICONEXCLAMATION);
int AppMessageBoxFormat(HWND hWnd, const UINT     nIDResource, const UINT uType = MB_OK | MB_ICONEXCLAMATION, ...);
int AppSystemMessageBox(HWND hWnd, const DWORD    dwErrorCode, const UINT uType = MB_OK | MB_ICONEXCLAMATION);

int AppLoadString(const UINT uID, wgc::tstring_t &tstr);

HINSTANCE GetInstanceHandle(void);
HINSTANCE GetResourceHandle(void);
void      SetResourceHandle(HINSTANCE hResource);
HACCEL    GetAcceleratorHandle(void);

HIMAGELIST GetImageList_ToolBarXP         (void);
HIMAGELIST GetImageList_ToolBarXP_Hot     (void);
HIMAGELIST GetImageList_ToolBarXP_Disabled(void);

void     GetWindowPlacementParameter(      WINDOWPLACEMENT &rWndPl);
void     SetWindowPlacementParameter(const WINDOWPLACEMENT &rWndPl);
void     GetMainFrameProperty(      MAINFRAME_PROPERTY &prMainFrame);
void     SetMainFrameProperty(const MAINFRAME_PROPERTY &prMainFrame);
void     GetEditViewProperty (      EDITVIEW_PROPERTY &prEditView,       KEYWORD_INFO &prKeyword, const UINT_PTR nIndex = 0);
void     SetEditViewProperty (const EDITVIEW_PROPERTY &prEditView, const KEYWORD_INFO &prKeyword, const UINT_PTR nIndex = 0);
UINT_PTR GetEditViewPropertySize(void);

void Station_NotifyExitFrameThread(FrameThread *pFrameThread);
void Station_SendHelpMessage      (const UINT uCommand);

#endif // __WINMAIN__
