// edit_manager.cpp cCve[Vt@C
#include "edit_manager.h"
#include <assert.h>                     // assert()


_SGC_BEGIN                              // namespace sgc {


////////////////////////////////////////////////////////////////////////////////
// public֐

////////////////////////////////////////////////////////////
// RXgNV

// RXgN^
edit_manager::edit_manager(void)
{
	// X^C
	m_style.readonly  = false;
	m_style.overwrite = false;

	set_text(NULL, 0);

	m_select.selected   = false;
	m_select.begin.it   = m_select.end.it = m_list.end();
	m_select.begin.xy.x = m_select.begin.xy.y = -1;
	m_select.end.xy.x   = m_select.end.xy.y   = -1;
}

// fXgN^
edit_manager::~edit_manager(void)
{
}


////////////////////////////////////////////////////////////
// 

// sTCY擾
size_t edit_manager::get_line_count(void) const
{
	return m_list.size();
}

// ݍs擪H
bool edit_manager::is_begin(void) const
{
	return m_list.begin() == m_iterator_now;
}

// ݍsH
bool edit_manager::is_end(void) const
{
	const_iterator_t p = m_iterator_now;
	return m_list.end() == ++p;
}


////////////////////////////////////////////////////////////
// W

// ݈ʒu擾
position_t edit_manager::get_xy(void) const
{
	return m_position;
}

// ݈ʒuݒ
edit_manager::const_iterator_t edit_manager::set_xy(const position_t &position)
{
	// Ky,x̏Őݒ肷邱
	set_y(position.y);
	set_x(position.x);

	return m_iterator_now;
}

// XW擾
intptr_t edit_manager::get_x(void) const
{
	return m_position.x;
}

// YW擾
intptr_t edit_manager::get_y(void) const
{
	return m_position.y;
}

// XWݒ
intptr_t edit_manager::set_x(const intptr_t x)
{
	m_position.x = x;

	// 
	const size_t length = m_iterator_now->length();
	if(m_position.x < 0 || static_cast<size_t>(m_position.x) > length)
	{
		m_position.x = length;
	}

	return m_position.x;
}

// YWݒ
intptr_t edit_manager::set_y(const intptr_t y)
{
	const linenumber_t lines = _GetPosition(y + 1, m_iterator_now);
	m_position.y = lines - 1;

	// xW̒
	const size_t length = m_iterator_now->length();
	if(static_cast<size_t>(m_position.x) > length)
	{
		m_position.x = length;
	}

	return m_position.y;
}


////////////////////////////////////////////////////////////
// Ce[^

// wsiYWj̃Ce[^擾
edit_manager::const_iterator_t edit_manager::get_iterator(const linenumber_t y) const
{
	edit_manager::const_iterator_t p;
	_GetPosition(y, p);

	return p;
}

// 擪ʒũCe[^擾
edit_manager::const_iterator_t edit_manager::get_iterator_begin(void) const
{
	return m_list.begin();
}

// ʒũCe[^擾
edit_manager::const_iterator_t edit_manager::get_iterator_end(void) const
{
	return m_list.end();
}

// ݈ʒũCe[^擾
edit_manager::const_iterator_t edit_manager::get_iterator_now(void) const
{
	return m_iterator_now;
}


////////////////////////////////////////////////////////////
// ̐ݒ/擾

// ֎~̐ݒ
void edit_manager::set_readonly(const bool readonly /* = true */)
{
	m_style.readonly = readonly;
}

// ֎~H
bool edit_manager::is_readonly(void) const
{
	return m_style.readonly;
}

// ㏑̐ݒ
void edit_manager::set_overwrite(const bool overwrite /* = true */)
{
	m_style.overwrite = overwrite;
}

// ㏑H
bool edit_manager::is_overwrite(void) const
{
	return m_style.overwrite;
}

// _[eB[tO̐ݒ
void edit_manager::set_modify(const bool modify /* = true */)
{
	m_undo_buffer.set_modify(modify);
}

// hLgύXĂ邩H
bool edit_manager::is_modified(void) const
{
	return m_undo_buffer.is_modified();
}


////////////////////////////////////////////////////////////
// ҏW

////////////////////////////////////////
// AhD/hD

// AhD
bool edit_manager::undo(modify_info &mi)
{
	if(is_readonly()) { return false; }

	undo_info info;
	if(!m_undo_buffer.undo(info)) { return false; }

	set_xy(info.position);

	mi.modified_line         = info.position.y;
	mi.is_modified_linecount = (info.text_append.size() != info.text_delete.size());

	// ͂ꂽ폜
	_DeleteLineList(info.text_append);

	// 폜ꂽ𕜊
	_Insert(info.text_delete, false, info.move_cursor);
	return true;
}

// hD
bool edit_manager::redo(modify_info &mi)
{
	if(is_readonly()) { return false; }

	undo_info info;
	if(!m_undo_buffer.redo(info)) { return false; }

	set_xy(info.position);

	mi.modified_line         = info.position.y;
	mi.is_modified_linecount = (info.text_append.size() != info.text_delete.size());

	// 폜
	_DeleteLineList(info.text_delete);

	// }
	_Insert(info.text_append, false, info.move_cursor);
	return true;
}

// AhDł邩H
bool edit_manager::can_undo(void) const
{
	return m_undo_buffer.can_undo();
}

// hDł邩H
bool edit_manager::can_redo(void) const
{
	return m_undo_buffer.can_redo();
}

// őAhD񐔂ݒ
intptr_t edit_manager::set_undo_limit(const intptr_t limit /* = -1 */)
{
	return m_undo_buffer.set_limit(limit);
}

// AhDobt@NA
void edit_manager::empty_undo_buffer(void)
{
	m_undo_buffer.clear();
}


////////////////////////////////////////
// obt@

// ݂̃obt@jĉsteLXgݒiǂݍݐp[hłIɐݒ肷j
bool edit_manager::set_text(const wchar_t *text, const size_t size)
{
	try
	{
		// {block}
		// eLXgݒ
		{
			linelist_t buffer;
			_CreateLineList(text, size, buffer);

			m_list.clear();
			m_list.splice(m_list.end(), buffer);
		}

		// {block}
		// ݈ʒuobt@̐擪ɂ
		{
			m_iterator_now = m_list.begin();
			m_position.x = 0;
			m_position.y = 0;
		}

		empty_undo_buffer();
		set_modify  (false);
		set_readonly(false);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}


// ݈ʒuɉsteLXg}
bool edit_manager::insert_text(const wchar_t *text, const size_t size, modify_info &mi)
{
	if(is_readonly()) { return false; }

	try
	{
		linelist_t buffer;
		_CreateLineList(text, size, buffer);

		// {block}
		// AhDobt@֒ǉ
		{
			undo_info info;
			info.move_cursor = true;
			info.position    = m_position;
			info.text_append = buffer;
			m_undo_buffer.push(info);
		}

		mi.modified_line         = m_position.y;
		mi.is_modified_linecount = (buffer.size() > 1);

		_Insert(buffer);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// ݈ʒuɉs}
bool edit_manager::insert_linefeed(modify_info &mi)
{
	if(is_readonly()) { return false; }

	try
	{
		iterator_t p = m_iterator_now;

		// ff
		assert(static_cast<size_t>(m_position.x) <= p->length());

		// s2܂ރobt@쐬
		linelist_t buffer;
		buffer.push_back(edit_line());
		buffer.push_back(edit_line());

		// {block}
		// AhDobt@֒ǉ
		{
			undo_info info;
			info.move_cursor = true;
			info.position    = m_position;
			info.text_append = buffer;
			m_undo_buffer.push(info);
		}

		mi.modified_line         = m_position.y;
		mi.is_modified_linecount = true;

		// obt@̓e}
		_Insert(buffer);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// 𑗐Mi}㏑fj
bool edit_manager::send_string(const wchar_t *wstr, const size_t length, modify_info &mi)
{
	if(is_readonly()) { return false; }

	// ff
	assert(static_cast<size_t>(m_position.x) <= m_iterator_now->length());

	try
	{
		undo_info info;
		info.move_cursor = true;
		info.position    = m_position;
		info.text_append.assign(1, edit_line(wstr));

		mi.modified_line         = m_position.y;
		mi.is_modified_linecount = false;

		// ㏑
		if(is_overwrite())
		{
			wstring_t str_delete;
			m_iterator_now->overwrite(m_position.x, wstr, length, &str_delete);
			info.text_delete.assign(1, edit_line(str_delete));
		}
		// }
		else
		{
			m_iterator_now->insert(m_position.x, wstr, length);
		}

		// AhDobt@֒ǉ
		m_undo_buffer.push(info);

		m_position.x += length;
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// ݈ʒu̕폜
bool edit_manager::delete_char(const bool left, modify_info &mi)
{
	if(is_readonly()) { return false; }

	try
	{
		undo_info info;

		// ̕폜iBackSpacej
		if(left)
		{
			info.move_cursor = true;

			// s̏ꍇ
			if(m_position.x == 0)
			{
				// obt@̐擪ȂI
				if(m_position.y == 0) { return false; }

				// {block}
				// 폜i[
				{
					iterator_t pos = m_iterator_now;
					pos--;
					info.text_delete.push_back(edit_line(pos->lf_type()));
					info.text_delete.push_back(edit_line());
				}

				// O̍sƘA
				_Combine(false, mi);
				goto push_undo;
			}
			m_position.x--;
		}
		// E̕폜iDeletej
		else
		{
			info.move_cursor = false;

			// s̏ꍇ
			const intptr_t length = m_iterator_now->length();
			if(m_position.x == length)
			{
				// obt@̖ȂI
				const intptr_t size = m_list.size() - 1;
				if(m_position.y == size) { return false; }

				// {block}
				// 폜i[
				{
					iterator_t pos = m_iterator_now;
					info.text_delete.push_back(edit_line(pos->lf_type()));
					info.text_delete.push_back(edit_line());
				}

				// ̍sƘA
				_Combine(true, mi);
				goto push_undo;
			}
		}

		// {block}
		// 폜
		{
			wstring_t deleted_string;
			m_iterator_now->erase(m_position.x, 1, &deleted_string);
			info.text_delete.assign(1, edit_line(deleted_string));

			mi.modified_line         = m_position.y;
			mi.is_modified_linecount = false;
		}

push_undo:
		// AhDobt@֒ǉ
		info.position = m_position;
		m_undo_buffer.push(info);

		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}


////////////////////////////////////////////////////////////////
// I

// I
void edit_manager::select_clear(void)
{
	m_select.selected = false;
}

// IJn
void edit_manager::select_begin(void)
{
	m_select.selected = true;
	m_select.begin.it = m_select.end.it = m_iterator_now;
	m_select.begin.xy = m_select.end.xy = m_position;
}

// I͈͂XV
void edit_manager::select_update(void)
{
	if(!is_selected())
	{
		select_begin();
	}
	else
	{
		m_select.end.it = m_iterator_now;
		m_select.end.xy = m_position;
	}
}

// I͈͂폜
void edit_manager::select_delete(modify_info &mi)
{
	if( is_readonly()) { return; }
	if(!is_selected()) { return; }

	select_t::select_pos_t begin = m_select.begin;
	select_t::select_pos_t end   = m_select.end;

	if((begin.xy.y > end.xy.y)
	|| ((begin.xy.y == end.xy.y) && (begin.xy.x > end.xy.x)))
	{
		std::swap(begin, end);
	}

	m_position = begin.xy;

	// 1sIĂȂꍇ
	if(begin.xy.y == end.xy.y)
	{
		begin.it->erase(begin.xy.x, end.xy.x - begin.xy.x);
	}
	// sIĂꍇ
	else
	{
		// 2sځ`ŏIs-1sڂ폜
		iterator_t p = begin.it;
		m_list.erase(++p, end.it);

		begin.it->erase(begin.xy.x);            // 1sڂ̑Iʒuȍ~폜
		end  .it->erase(0         , end.xy.x);  // ŏIs̑Iʒu܂ł폜

		_Combine(true, mi);
	}
}

// I͈͂̕擾
void edit_manager::select_get_string(wstring_t &wstr) const
{
	if(!is_selected()) { return; }

	select_t::select_pos_t begin = m_select.begin;
	select_t::select_pos_t end   = m_select.end;

	if((begin.xy.y > end.xy.y)
	|| ((begin.xy.y == end.xy.y) && (begin.xy.x > end.xy.x)))
	{
		std::swap(begin, end);
	}

	// 1sIĂȂꍇ
	if(begin.xy.y == end.xy.y)
	{
		wstr = begin.it->substr(begin.xy.x, begin.xy.y - begin.xy.x);
	}
	// sIĂꍇ
	else
	{
		// 1s
		const_iterator_t p = begin.it;
		wstr  = p->substr(begin.xy.x);
		wstr += charcode_get_linefeed_string(p->lf_type());

		// 2sځ`ŏIs-1s
		while(p != end.it)
		{
			wstr += p->c_str();
			wstr += charcode_get_linefeed_string(p->lf_type());
			p++;
		}

		// ŏIs
		if(p != m_list.end())
		{
			wstr += p->substr(0, end.xy.x);
		}
	}
}

// IĂ邩H
bool edit_manager::is_selected(void) const
{
	// IĂȂFALSE
	if(!m_select.selected)
	{
		return false;
	}
	// IĂĂJnʒuIʒuȂFALSE
	if(m_select.begin.xy.x == m_select.end.xy.x && m_select.begin.xy.y == m_select.end.xy.y)
	{
		return false;
	}
	// ȊOȂTRUE
	return true;
}


////////////////////////////////////////////////////////////////////////////////
// protected֐

// ݍsƎorO̍sA
bool edit_manager::_Combine(const bool forward, modify_info &mi)
{
	iterator_t p = m_iterator_now;               // Ai폜鑤j

	// ̍sA
	if(forward)
	{
		if(is_end()) { return false; }

		// A̍s
		p++;
	}
	// O̍sA
	else
	{
		if(is_begin()) { return false; }

		// A恁O̍s
		m_iterator_now--;
		m_position.y--;
	}

	mi.modified_line         = m_position.y;
	mi.is_modified_linecount = true;

	m_position.x = m_iterator_now->length();

	// A
	*m_iterator_now += *p;
	m_list.erase(p);

	return true;
}


// pos폜
void edit_manager::_Delete(iterator_t &pos, const size_t count /* = 1 */, const bool forward /* = true */)
{
	iterator_t begin = pos;
	iterator_t end   = pos;

	// O폜
	if(forward)
	{
		for(size_t i = 0; i < count; i++)
		{
			if(end == m_list.end())
			{
				break;
			}
			end++;
		}
	}
	// 폜
	else
	{
		for(size_t i = 0; i < count; i++)
		{
			if(begin == m_list.begin())
			{
				break;
			}
			begin--;
		}
	}

	// pos͍폜s̎w
	pos = m_list.erase(begin, end);
}

// ݈ʒuobt@e폜iundo() / redo() Ŏgpj
void edit_manager::_DeleteLineList(const linelist_t &buffer)
{
	if(buffer.empty()) { return; }

	const size_t delete_lines = buffer.size();

	// Eij폜
	if(delete_lines >= 2)
	{
		iterator_t pos = m_iterator_now;
		pos++;
		_Delete(pos, delete_lines - 2);

		const edit_line rear  = pos->substr(buffer.back().length()); pos--;
		const edit_line front = pos->substr(0, pos->length() - buffer.front().length());
		_Delete(pos, 2);

		m_iterator_now = m_list.insert(pos, front + rear);
	}
	else
	{
		const size_t length = buffer.front().length();
		m_iterator_now->erase(m_position.x, length);
	}
}

// ݈ʒubuffer}
void edit_manager::_Insert(linelist_t &buffer, const bool move_buffer /* = true */, const bool move_cursor /* = true */)
{
	if(buffer.empty()) { return; }

	iterator_t p = m_iterator_now;

	const size_t lines  = buffer.size();
	const size_t length = buffer.back().length();

	// ݈ʒu̕𕪊
	edit_line front, rear;
	p->split(m_position.x, front, rear);

	// splice() p̃obt@쐬
	linelist_t buffer_tmp;
	if(move_buffer)
	{
		buffer_tmp.splice(buffer_tmp.end(), buffer);
	}
	else
	{
		buffer_tmp = buffer;
	}

	// O̕ǉ
	buffer_tmp.front() = front + buffer_tmp.front();
	buffer_tmp.back () = buffer_tmp.back() + rear;

	// obt@̓e}
	iterator_t p_insert = p;
	m_list.splice(++p_insert, buffer_tmp);

	// ʒuXV
	if(move_cursor)
	{
		if(lines > 1) { m_position.x  = length; }
		else          { m_position.x += length; }
		m_position.y += (lines - 1);
		m_iterator_now = --p_insert;
	}
	else
	{
		// ̌Ō݈ʒu폜̂ŃCe[^1i߂
		m_iterator_now++;
	}

	// ݈ʒu폜
	_Delete(p);
}


// poscountsXN[
intptr_t edit_manager::_Scroll(const intptr_t count, const_iterator_t &pos) const
{
	if(count > 0)
	{
		return _ScrollForward(count, pos);
	}
	else
	{
		return -_ScrollBackward(-count, pos);
	}
}

// ɃXN[
intptr_t edit_manager::_ScrollForward(const size_t count, const_iterator_t &pos) const
{
	// ݈ʒuXV
	for(size_t i = 0; i < count; i++)
	{
		const_iterator_t p = pos;
		if(++p == get_iterator_end())
		{
			return i;
		}
		pos++;
	}

	// ۂɃXN[sԂ
	return count;
}

// 擪ɃXN[
intptr_t edit_manager::_ScrollBackward(const size_t count, const_iterator_t &pos) const
{
	// ݈ʒuXV
	for(size_t i = 0; i < count; i++)
	{
		if(get_iterator_begin() == pos)
		{
			return i;
		}
		pos--;
	}

	// ۂɃXN[sԂ
	return count;
}


// wsԍ̃Ce[^擾ilinenumber==0 Ȃ疖Alinenumber==1 Ȃ擪j
edit_manager::linenumber_t edit_manager::_GetPosition(const linenumber_t linenumber, const_iterator_t &pos) const
{
	const size_t        line_count = get_line_count();
	const iterator_t   &base_iterator   = m_iterator_now;   // ʒu݈ʒu
	const linenumber_t &base_linenumber = m_position.y + 1;

	// 擪
	if(linenumber == 1)
	{
		pos = get_iterator_begin();
		return 1;
	}
	// 
	if(linenumber == 0 || linenumber >= line_count)
	{
		pos = get_iterator_end();
		pos--;
		return line_count;
	}

	// ʒu擪
	if(linenumber < base_linenumber)
	{
		const linenumber_t diff = base_linenumber - linenumber;

		// 擪ɋ߂
		if(linenumber < diff)
		{
			// 擪猟
			pos = get_iterator_begin();
			_ScrollForward(linenumber - 1, pos);
			return linenumber;
		}
		// ʒuɋ߂
		else
		{
			// ʒu猟
			pos = base_iterator;
			_ScrollBackward(diff, pos);
			return linenumber;
		}
	}
	// ʒu薖
	if(linenumber > base_linenumber)
	{
		const linenumber_t diff = linenumber - base_linenumber;

		// ɋ߂
		if(line_count - linenumber < diff)
		{
			// 猟
			pos = get_iterator_end();
			pos--;
			_ScrollBackward(line_count - linenumber, pos);
			return linenumber;
		}
		// ʒuɋ߂
		else
		{
			// ʒu猟
			pos = base_iterator;
			_ScrollForward(diff, pos);
			return linenumber;
		}
	}

	// ʒu
	pos = base_iterator;
	return linenumber;
}


// s̃eLXgAsȂ̕񃊃Xg쐬
void edit_manager::_CreateLineList(const wchar_t *text, const size_t size, linelist_t &linelist)
{
	size_t size2 = size;
	for(;;)
	{
		// sʒu
		charcode_linefeed_t lf_type;
		size_t skip;

		const size_t pos = charcode_find_linefeed(text, size2, lf_type, skip);
		if(pos == CHARCODE_POS_INVALID)
		{
			// ŏIs
			linelist.push_back(edit_line(text, size2));
			break;
		}

		// ؂o
		linelist.push_back(edit_line(text, pos, lf_type));

		// {block}
		// ̈ʒuvZ
		{
			const size_t offset = pos + skip;
			text  += offset;
			size2 -= offset;
		}
	}
}

_SGC_END                                // }
