// COM_IDataObject.h cf[^IuWFNg
#ifndef __WGC_COM_IDATAOBJECT__
#define __WGC_COM_IDATAOBJECT__

#include "COM.h"
#include <list>


_WGC_BEGIN                              // namespace wgc {

// IDataObject ̃ftHgCvg
class COM_IDataObject : public IDataObject
{
public:
	static IDataObject *CreateInstance(void);

	// IUnknown \bh
	HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid, void **ppv);
	ULONG   STDMETHODCALLTYPE AddRef(void);
	ULONG   STDMETHODCALLTYPE Release(void);

	// IDataObject \bh
	HRESULT STDMETHODCALLTYPE GetData              (FORMATETC *pFormatEtc, STGMEDIUM *pMedium);
	HRESULT STDMETHODCALLTYPE GetDataHere          (FORMATETC *pFormatEtc, STGMEDIUM *pMedium);
	HRESULT STDMETHODCALLTYPE QueryGetData         (FORMATETC *pFormatEtc);
	HRESULT STDMETHODCALLTYPE GetCanonicalFormatEtc(FORMATETC *pFormatEtcIn, FORMATETC *pFormatEtcInOut);
	HRESULT STDMETHODCALLTYPE SetData              (FORMATETC *pFormatEtc, STGMEDIUM *pMedium, BOOL fRelease);
	HRESULT STDMETHODCALLTYPE EnumFormatEtc        (DWORD dwDirection, IEnumFORMATETC **ppEnumFormatEtc);
	HRESULT STDMETHODCALLTYPE DAdvise              (FORMATETC *pFormatEtc, DWORD advf, IAdviseSink *pAdvSink, DWORD *pdwConnection);
	HRESULT STDMETHODCALLTYPE DUnadvise            (DWORD dwConnection);
	HRESULT STDMETHODCALLTYPE EnumDAdvise          (IEnumSTATDATA **ppenumAdvise);

private:
	typedef struct _object_t
	{
		BOOL      release;
		FORMATETC format;
		STGMEDIUM medium;
	} object_t;
	typedef std::list<object_t> object_list_t;

	object_list_t m_object_list;
	LONG m_lRefCount;                       // QƃJEg

	// CreateInstance() ȊOŃCX^X쐬łȂ悤ɁARXgN^privateɂ
	COM_IDataObject(void);
	virtual ~COM_IDataObject(void);

	static HRESULT _DuplicateMedium(STGMEDIUM *dst, const STGMEDIUM *src, const CLIPFORMAT cfFormat);
};

_WGC_END                                // }

#endif // __WGC_COM_IDATAOBJECT__
