// DeviceContext.cpp cCve[Vt@C
#include "DeviceContext.h"


_WGC_BEGIN                              // namespace wgc {

////////////////////////////////////////////////////////////////////////////////
// foCXReLXg


////////////////////////////////////////////////////////////
// RXgNV

DeviceContext::DeviceContext(HDC hDC)
	: m_hDC(NULL)
{
	m_hDC = hDC;
}

DeviceContext::~DeviceContext(void)
{
}

BOOL DeviceContext::Delete(void)
{
	HDC hTmp = m_hDC;
	m_hDC = NULL;

	return ::DeleteDC(hTmp);
}


BOOL DeviceContext::GetTextMetrics(TEXTMETRIC &rMetrics) const
{
	return ::GetTextMetrics(m_hDC, &rMetrics);
}

int DeviceContext::GetDeviceCaps(const int nIndex) const
{
	return ::GetDeviceCaps(m_hDC, nIndex);
}


////////////////////////////////////////////////////////////
// Iy[V

HGDIOBJ DeviceContext::SelectObject(GdiObject &rNewObject)
{
	return ::SelectObject(m_hDC, rNewObject);
}

HPEN DeviceContext::SelectObject(GdiPen &rNewPen)
{
	HGDIOBJ hOldObject = ::SelectObject(m_hDC, rNewPen);

	return reinterpret_cast<HPEN>(hOldObject);
}

HFONT DeviceContext::SelectObject(GdiFont &rNewFont)
{
	HGDIOBJ hOldObject = ::SelectObject(m_hDC, rNewFont);

	return reinterpret_cast<HFONT>(hOldObject);
}


////////////////////////////////////////////////////////////
// OiF/wiF

COLORREF DeviceContext::GetTextColor(void) const
{
	return ::GetTextColor(m_hDC);
}

COLORREF DeviceContext::GetBkColor(void) const
{
	return ::GetBkColor(m_hDC);
}

COLORREF DeviceContext::SetTextColor(const COLORREF color)
{
	return ::SetTextColor(m_hDC, color);
}

COLORREF DeviceContext::SetBkColor(const COLORREF color)
{
	return ::SetBkColor(m_hDC, color);
}


////////////////////////////////////////////////////////////
// obNOEh[h

int DeviceContext::GetBkMode(void)
{
	return ::GetBkMode(m_hDC);
}

int DeviceContext::SetBkMode(const int iBkMode)
{
	return ::SetBkMode(m_hDC, iBkMode);
}


////////////////////////////////////////////////////////////
// 

BOOL DeviceContext::GetCharWidth(const UINT nFirstChar, const UINT nLastChar, LPINT lpBuffer) const
{
	return ::GetCharWidth(m_hDC, nFirstChar, nLastChar, lpBuffer);
}

BOOL DeviceContext::GetCharWidthWide(const UINT nFirstChar, const UINT nLastChar, LPINT lpBuffer) const
{
	return ::GetCharWidthW(m_hDC, nFirstChar, nLastChar, lpBuffer);
}


////////////////////////////////////////////////////////////
// NbsÖ

int DeviceContext::GetClipBox(RECT &rRect) const
{
	return ::GetClipBox(m_hDC, &rRect);
}

// VNbsÖ쐬
int DeviceContext::SetClipRect(const RECT &rRect)
{
	ClearClip();
	return IntersectClipRect(rRect);
}

// NbsÖNA
int DeviceContext::ClearClip(void)
{
	return ::SelectClipRgn(m_hDC, NULL);
}

// ݂̃NbsÖ rRect VNbsÖ쐬
int DeviceContext::IntersectClipRect(const RECT &rRect)
{
	return ::IntersectClipRect(
		m_hDC,
		rRect.left, rRect.top,
		rRect.right, rRect.bottom);
}

// ݂̃NbsÖ悩 rRect 菜
int DeviceContext::ExcludeClipRect(const RECT &rRect)
{
	return ::ExcludeClipRect(
		m_hDC,
		rRect.left, rRect.top,
		rRect.right, rRect.bottom);
}

BOOL DeviceContext::RectVisible(const RECT &rRect) const
{
	return ::RectVisible(m_hDC, &rRect);
}

BOOL DeviceContext::PtVisible(const POINT &rPoint) const
{
	return ::PtVisible(m_hDC, rPoint.x, rPoint.y);
}


////////////////////////////////////////////////////////////
// hԂ

BOOL DeviceContext::FillRect(const RECT &rect, HBRUSH hBrush)
{
	return ::FillRect(m_hDC, &rect, hBrush);
}

BOOL DeviceContext::FillSolidRect(const RECT &rect, const COLORREF color)
{
	const POINT pt = {0, 0};
	SetBkColor(color);
	return ExtTextOut(pt, ETO_OPAQUE, rect, tstring_t());
}


////////////////////////////////////////////////////////////
// `

BOOL DeviceContext::DrawFocusRect(const RECT &rect)
{
	return ::DrawFocusRect(m_hDC, &rect);
}

BOOL DeviceContext::DrawEdge(
	const RECT &rect,
	const UINT edge     /* = EDGE_ETCHED */,
	const UINT grfFlags /* = BF_RECT */)
{
	RECT tmp = rect;
	return ::DrawEdge(m_hDC, &tmp, edge, grfFlags);
}


////////////////////////////////////////////////////////////

BOOL DeviceContext::MoveToEx(
	const int x,
	const int y,
	LPPOINT lpPoint)
{
	return ::MoveToEx(m_hDC, x, y, lpPoint);
}

BOOL DeviceContext::MoveTo(
	const int x,
	const int y)
{
	return MoveToEx(x, y, NULL);
}

BOOL DeviceContext::LineTo(
	const int x,
	const int y)
{
	return ::LineTo(m_hDC, x, y);
}

BOOL DeviceContext::Polyline(
	const POINT ptVertexes[], const UINT nCount)
{
	return ::Polyline(m_hDC, ptVertexes, nCount);
}

BOOL DeviceContext::Polygon(const POINT ptVertexes[], const UINT nCount)
{
	return ::Polygon(m_hDC, ptVertexes, nCount);
}

BOOL DeviceContext::PolyPolyline(const POINT ptVertexes[], const DWORD dwPolyPoints[], const DWORD dwCount)
{
	return ::PolyPolyline(m_hDC, ptVertexes, dwPolyPoints, dwCount);
}

BOOL DeviceContext::PolyPolygon(const POINT ptVertexes[], const INT nPolyPoints[], const INT nCount)
{
	return ::PolyPolygon(m_hDC, ptVertexes, nPolyPoints, nCount);
}


////////////////////////////////////////////////////////////
// eLXg`

// P`
BOOL DeviceContext::TextOut(const int x, const int y, LPCTSTR lpString, const int nCount)
{
	return ::TextOut(m_hDC, x, y, lpString, nCount);
}

BOOL DeviceContext::TextOut(const int x, const int y, const tstring_t &tstr)
{
	return TextOut(
		x, y,
		tstr.c_str(),
		static_cast<int>(tstr.length()));
}

BOOL DeviceContext::TextOut(const POINT &pt, LPCTSTR lpString, const int nCount)
{
	return TextOut(pt.x, pt.y, lpString, nCount);
}

BOOL DeviceContext::TextOut(const POINT &pt, const tstring_t &tstr)
{
	return TextOut(pt.x, pt.y, tstr);
}

// PCh`
BOOL DeviceContext::TextOutWide(const int x, const int y, LPCWSTR lpString, const int nCount)
{
	return ::TextOutW(m_hDC, x, y, lpString, nCount);
}

BOOL DeviceContext::TextOutWide(const int x, const int y, const wstring_t &wstr)
{
	return TextOutWide(
		x, y,
		wstr.c_str(),
		static_cast<int>(wstr.length()));
}

BOOL DeviceContext::TextOutWide(const POINT &pt, LPCWSTR lpString, const int nCount)
{
	return TextOutWide(pt.x, pt.y, lpString, nCount);
}

BOOL DeviceContext::TextOutWide(const POINT &pt, const wstring_t &wstr)
{
	return TextOutWide(pt.x, pt.y, wstr);
}


// g`
BOOL DeviceContext::ExtTextOut(
	const int x,
	const int y,
	const UINT fuOptions,
	const RECT &rect,
	LPCTSTR lpString,
	const UINT nCount,
	const int *lpDx   /* = NULL */)
{
	return ::ExtTextOut(
		m_hDC,
		x, y,
		fuOptions,
		&rect,
		lpString, nCount,
		lpDx);
}

BOOL DeviceContext::ExtTextOut(
	const int x,
	const int y,
	const UINT fuOptions,
	const RECT &rect,
	const tstring_t &tstr,
	const int *lpDx /* = NULL */)
{
	return ExtTextOut(
		x, y,
		fuOptions,
		rect,
		tstr.c_str(), static_cast<UINT>(tstr.length()),
		lpDx);
}

BOOL DeviceContext::ExtTextOut(
	const POINT &pt,
	const UINT fuOptions,
	const RECT &rect,
	LPCTSTR lpString,
	const UINT nCount,
	const int *lpDx   /* = NULL */)
{
	return ExtTextOut(
		pt.x, pt.y,
		fuOptions,
		rect,
		lpString, nCount,
		lpDx);
}

BOOL DeviceContext::ExtTextOut(
	const POINT &pt,
	const UINT fuOptions,
	const RECT &rect,
	const tstring_t &tstr,
	const int *lpDx /* = NULL */)
{
	return ExtTextOut(
		pt.x, pt.y,
		fuOptions,
		rect,
		tstr,
		lpDx);
}


// gCh`
BOOL DeviceContext::ExtTextOutWide(
	const int x,
	const int y,
	const UINT fuOptions,
	const RECT &rect,
	LPCWSTR lpString,
	const UINT nCount,
	const int *lpDx   /* = NULL */)
{
	return ::ExtTextOutW(
		m_hDC,
		x, y,
		fuOptions,
		&rect,
		lpString, nCount,
		lpDx);
}

BOOL DeviceContext::ExtTextOutWide(
	const int x,
	const int y,
	const UINT fuOptions,
	const RECT &rect,
	const wstring_t &wstr,
	const int *lpDx   /* = NULL */)
{
	return ExtTextOutWide(
		x, y,
		fuOptions,
		rect,
		wstr.c_str(), static_cast<UINT>(wstr.length()),
		lpDx);
}

BOOL DeviceContext::ExtTextOutWide(
	const POINT &pt,
	const UINT fuOptions,
	const RECT &rect,
	LPCWSTR lpString,
	const UINT nCount /* = -1 */,
	const int *lpDx   /* = NULL */)
{
	return ExtTextOutWide(
		pt.x, pt.y,
		fuOptions,
		rect,
		lpString, nCount,
		lpDx);
}

BOOL DeviceContext::ExtTextOutWide(
	const POINT &pt,
	const UINT fuOptions,
	const RECT &rect,
	const wstring_t &wstr,
	const int *lpDx   /* = NULL */)
{
	return ExtTextOutWide(
		pt.x, pt.y,
		fuOptions,
		rect,
		wstr,
		lpDx);
}


// Ct`
int DeviceContext::DrawText(LPCTSTR lpString, const int nCount, RECT &rect, const UINT uFormat /* = DT_LEFT | DT_NOPREFIX */)
{
	return ::DrawText(
		m_hDC,
		lpString, nCount,
		&rect, uFormat);
}

int DeviceContext::DrawText(const tstring_t &tstr, RECT &rect, const UINT uFormat /* = DT_LEFT | DT_NOPREFIX */)
{
	return DrawText(
		tstr.c_str(),
		static_cast<int>(tstr.length()),
		rect,
		uFormat);
}


BOOL DeviceContext::GetTextExtent(const tstring_t &tstr, SIZE &size) const
{
	return ::GetTextExtentPoint32(
		m_hDC,
		tstr.c_str(),
		static_cast<int>(tstr.length()),
		&size);
}


////////////////////////////////////////////////////////////////////////////////
// GDIIuWFNg̎IJ
auto_SelectObject::auto_SelectObject(DeviceContext &dc, GdiObject &gdi)
	: m_dc(dc), m_old_object(dc.SelectObject(gdi))
{
}

auto_SelectObject::~auto_SelectObject(void)
{
	m_dc.SelectObject(m_old_object);
}


////////////////////////////////////////////////////////////////////////////////
// hDC

////////////////////////////////////////////////////////////////////////////////
// NCAgDC
DeviceContext_Client::DeviceContext_Client(HWND hWnd)
	: DeviceContext(::GetDC(hWnd))
{
	m_hWnd = hWnd;
}

DeviceContext_Client::~DeviceContext_Client(void)
{
	::ReleaseDC(m_hWnd, m_hDC);
	m_hDC = NULL;
}


////////////////////////////////////////////////////////////////////////////////
// EChEDC
DeviceContext_Window::DeviceContext_Window(HWND hWnd)
	: DeviceContext(::GetWindowDC(hWnd))
{
	m_hWnd = hWnd;
}

DeviceContext_Window::~DeviceContext_Window(void)
{
	::ReleaseDC(m_hWnd, m_hDC);
	m_hDC = NULL;
}


////////////////////////////////////////////////////////////////////////////////
// yCgDC
DeviceContext_Paint::DeviceContext_Paint(HWND hWnd, LPPAINTSTRUCT lpPaint /* = NULL */)
	: DeviceContext(::BeginPaint(hWnd, &m_ps))
{
	m_hWnd = hWnd;
	if(lpPaint != NULL)
	{
		*lpPaint = m_ps;
	}
}

DeviceContext_Paint::~DeviceContext_Paint(void)
{
	::EndPaint(m_hWnd, &m_ps);
	m_hDC = NULL;
}


////////////////////////////////////////////////////////////////////////////////
// DC
DeviceContext_Memory::DeviceContext_Memory(HDC hDC)
	: DeviceContext(::CreateCompatibleDC(hDC))
{
}

DeviceContext_Memory::~DeviceContext_Memory(void)
{
	Delete();
}


////////////////////////////////////////////////////////////////////////////////
// v^DC
DeviceContext_Printer::DeviceContext_Printer(
	LPCTSTR lpszDriver,
	LPCTSTR lpszDevice,
	CONST DEVMODE *lpInitData /* = NULL */)
	: DeviceContext(::CreateDC(lpszDriver, lpszDevice, NULL, lpInitData))
{
}

DeviceContext_Printer::~DeviceContext_Printer(void)
{
	Delete();
}

int DeviceContext_Printer::StartDoc(const DOCINFO &rDocInfo)
{
	return ::StartDoc(m_hDC, &rDocInfo);
}

int DeviceContext_Printer::EndDoc(void)
{
	return ::EndDoc(m_hDC);
}

int DeviceContext_Printer::AbortDoc(void)
{
	return ::AbortDoc(m_hDC);
}

int DeviceContext_Printer::StartPage(void)
{
	return ::StartPage(m_hDC);
}

int DeviceContext_Printer::EndPage(void)
{
	return ::EndPage(m_hDC);
}

_WGC_END                                // }
