// COM_OleDropSource.cpp cCve[Vt@C
#include "COM_OleDropSource.h"
#include "../COM_IDropSource.h"
#include "../COM_IDataObject.h"


_WXC_BEGIN                              // namespace wxc {


////////////////////////////////////////////////////////////
// RXgNV

COM_OleDropSource::COM_OleDropSource(IUnknown *pUnknown /* = NULL */)
	: m_pDropSource(NULL), m_pDataObject(NULL)
{
	// pUnknown C^[tF[X擾
	if(pUnknown != NULL)
	{
		pUnknown->QueryInterface(
			IID_IDropSource,
			reinterpret_cast<void **>(&m_pDropSource));

		pUnknown->QueryInterface(
			IID_IDataObject,
			reinterpret_cast<void **>(&m_pDataObject));
	}

	// C^[tF[X̎擾ɎsAftHg̃C^[tF[X擾
	if(m_pDropSource == NULL) { m_pDropSource = wgc::COM_IDropSource::CreateInstance(); }
	if(m_pDataObject == NULL) { m_pDataObject = wgc::COM_IDataObject::CreateInstance(); }
}

COM_OleDropSource::~COM_OleDropSource()
{
	m_pDataObject->Release();
	m_pDropSource->Release();
}

void COM_OleDropSource::CacheGlobalData(
	const CLIPFORMAT cfFormat,
	HGLOBAL hGlobal)
{
	FORMATETC format;
	format.cfFormat = cfFormat;
	format.dwAspect = DVASPECT_CONTENT;
	format.lindex   = -1;
	format.ptd      = NULL;
	format.tymed    = TYMED_HGLOBAL;

	STGMEDIUM medium;
	medium.hGlobal        = hGlobal;
	medium.tymed          = TYMED_HGLOBAL;
	medium.pUnkForRelease = NULL;

	// f[^i[i m_pDataObject ɔCj
	m_pDataObject->SetData(&format, &medium, TRUE);
}

DWORD COM_OleDropSource::DoDragDrop(
	const DWORD dwOKEffects /* = DROPEFFECT_COPY | DROPEFFECT_MOVE | DROPEFFECT_LINK */)
{
	DWORD dwEffect = DROPEFFECT_NONE;
	::DoDragDrop(m_pDataObject, m_pDropSource, dwOKEffects, &dwEffect);
	return dwEffect;
}

_WXC_END                                // }
