// edit_manager.cpp cCve[Vt@C
#include "edit_manager.h"
#include <assert.h>                     // assert()


_SGC_BEGIN                              // namespace sgc {


////////////////////////////////////////////////////////////////////////////////
// public֐

////////////////////////////////////////////////////////////
// RXgNV

// RXgN^
edit_manager::edit_manager(void)
{
	// X^C
	m_style.readonly  = false;
	m_style.overwrite = false;

	set_text(NULL, 0);

	m_select.begin.it   = m_select.end.it = m_list.begin();
	m_select.begin.xy.x = m_select.begin.xy.y = 0;
	m_select.end.xy.x   = m_select.end.xy.y   = 0;
}

// fXgN^
edit_manager::~edit_manager(void)
{
}


////////////////////////////////////////////////////////////
// 

// ݍs擾
void edit_manager::get_line(wstring_t &line) const
{
	m_pos.it->line(line, !is_end());
}

// sTCY擾
size_t edit_manager::get_line_count(void) const
{
	return m_list.size();
}

// P̋؂
size_t edit_manager::find_word_break(const bool forward /* = true */) const
{
	return _FindWordBreak(m_pos.it->c_str(), m_pos.it->length(), m_pos.xy.x, forward);
}

// 擪H
bool edit_manager::is_begin(void) const
{
	return m_list.begin() == m_pos.it;
}

// H
bool edit_manager::is_end(void) const
{
	const_iterator_t p = m_pos.it;
	return m_list.end() == ++p;
}

// sH
bool edit_manager::is_head(void) const
{
	return m_pos.xy.x == 0;
}

// sH
bool edit_manager::is_tail(void) const
{
	return static_cast<size_t>(m_pos.xy.x) == m_pos.it->length();
}


////////////////////////////////////////////////////////////
// W

// ݈ʒu擾
position_t edit_manager::get_xy(void) const
{
	return m_pos.xy;
}

// ݈ʒuݒ
edit_manager::const_iterator_t edit_manager::set_xy(const position_t &position, const bool update_selection /* = false */)
{
	// Ky,x̏Őݒ肷邱
	set_y(position.y, update_selection);
	set_x(position.x, update_selection);

	return m_pos.it;
}

// XW擾
intptr_t edit_manager::get_x(void) const
{
	return m_pos.xy.x;
}

// YW擾
intptr_t edit_manager::get_y(void) const
{
	return m_pos.xy.y;
}

// XWݒ
intptr_t edit_manager::set_x(const intptr_t x, const bool update_selection /* = false */)
{
	m_pos.xy.x = x;

	// 
	const size_t length = m_pos.it->length();
	if(m_pos.xy.x < 0 || static_cast<size_t>(m_pos.xy.x) > length)
	{
		m_pos.xy.x = length;
	}

	// I͈͂XV
	select_update(!update_selection);

	return m_pos.xy.x;
}

// YWݒ
intptr_t edit_manager::set_y(const intptr_t y, const bool update_selection /* = false */)
{
	const linenumber_t lines = _GetPosition(y + 1, m_pos.it);
	m_pos.xy.y = lines - 1;

	// xWI0ɂ
	// i̖ŕK݂xWړ̍œKȏꏊƂ͌Ȃ߁AU0ɂj
	m_pos.xy.x = 0;

	// I͈͂XV
	select_update(!update_selection);

	return m_pos.xy.y;
}

intptr_t edit_manager::shift_x(const intptr_t dx, const bool update_selection /* = false */)
{
	const intptr_t x = m_pos.xy.x + dx;
	return set_x(x, update_selection);
}

intptr_t edit_manager::shift_y(const intptr_t dy, const bool update_selection /* = false */)
{
	intptr_t y = m_pos.xy.y + dy;
	if(y < 0) { y = 0; }
	return set_y(y, update_selection);
}


////////////////////////////////////////////////////////////
// Ce[^

// wsiYWj̃Ce[^擾
edit_manager::const_iterator_t edit_manager::get_iterator(const linenumber_t y) const
{
	edit_manager::const_iterator_t p;
	_GetPosition(y, p);

	return p;
}

// 擪ʒũCe[^擾
edit_manager::const_iterator_t edit_manager::get_iterator_begin(void) const
{
	return m_list.begin();
}

// ʒũCe[^擾
edit_manager::const_iterator_t edit_manager::get_iterator_end(void) const
{
	return m_list.end();
}

// ݈ʒũCe[^擾
edit_manager::const_iterator_t edit_manager::get_iterator_now(void) const
{
	return m_pos.it;
}


////////////////////////////////////////////////////////////
// ̐ݒ/擾

// ֎~̐ݒ
void edit_manager::set_readonly(const bool readonly /* = true */)
{
	m_style.readonly = readonly;
}

// ֎~H
bool edit_manager::is_readonly(void) const
{
	return m_style.readonly;
}

// ㏑̐ݒ
void edit_manager::set_overwrite(const bool overwrite /* = true */)
{
	m_style.overwrite = overwrite;
}

// ㏑H
bool edit_manager::is_overwrite(void) const
{
	return m_style.overwrite;
}

// _[eB[tO̐ݒ
void edit_manager::set_modify(const bool modify /* = true */)
{
	m_undo_buffer.set_modify(modify);
}

// hLgύXĂ邩H
bool edit_manager::is_modified(void) const
{
	return m_undo_buffer.is_modified();
}


////////////////////////////////////////////////////////////
// ҏW

////////////////////////////////////////
// AhD/hD

// AhD
bool edit_manager::undo(modify_info &mi)
{
	if(is_readonly()) { return false; }

	undo_info info;
	if(!m_undo_buffer.undo(info)) { return false; }

	set_xy(info.position);

	mi.modified_line         = info.position.y;
	mi.is_modified_linecount = (info.text_append.size() != info.text_delete.size());

	// ͂ꂽ폜
	_DeleteLineList(info.text_append);

	// 폜ꂽ𕜊
	_Insert(info.text_delete, false, info.move_cursor);
	return true;
}

// hD
bool edit_manager::redo(modify_info &mi)
{
	if(is_readonly()) { return false; }

	undo_info info;
	if(!m_undo_buffer.redo(info)) { return false; }

	set_xy(info.position);

	mi.modified_line         = info.position.y;
	mi.is_modified_linecount = (info.text_append.size() != info.text_delete.size());

	// 폜
	_DeleteLineList(info.text_delete);

	// }
	_Insert(info.text_append, false, info.move_cursor);
	return true;
}

// AhDł邩H
bool edit_manager::can_undo(void) const
{
	return m_undo_buffer.can_undo();
}

// hDł邩H
bool edit_manager::can_redo(void) const
{
	return m_undo_buffer.can_redo();
}

// őAhD񐔂ݒ
intptr_t edit_manager::set_undo_limit(const intptr_t limit /* = -1 */)
{
	return m_undo_buffer.set_limit(limit);
}

// AhDobt@NA
void edit_manager::empty_undo_buffer(void)
{
	m_undo_buffer.clear();
}


////////////////////////////////////////
// obt@

// ݂̃obt@jĉsteLXgݒiǂݍݐp[hłIɐݒ肷j
bool edit_manager::set_text(const wchar_t *text, const size_t size)
{
	try
	{
		// {block}
		// eLXgݒ
		{
			linelist_t buffer;
			_CreateLineList(text, size, buffer);

			m_list.clear();
			m_list.splice(m_list.end(), buffer);
		}

		// {block}
		// ݈ʒuobt@̐擪ɂ
		{
			m_pos.it = m_list.begin();
			m_pos.xy.x = 0;
			m_pos.xy.y = 0;
		}

		empty_undo_buffer();
		set_modify  (false);
		set_readonly(false);
		select_update(true);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}


// ݈ʒuɉsteLXg}
bool edit_manager::insert_text(const wchar_t *text, const size_t size, modify_info &mi)
{
	if(is_readonly()) { return false; }
	if(size == 0    ) { return false; }

	try
	{
		linelist_t buffer;
		_CreateLineList(text, size, buffer);

		// {block}
		// AhDobt@֒ǉ
		{
			undo_info info;
			info.move_cursor = true;
			info.position    = m_pos.xy;
			info.text_append = buffer;

			// IĂΑI͈͂폜
			if(is_selected())
			{
				pos_t begin, end;
				_SelectGetRange(begin, end);
				_RangeDelete(begin, end, info, mi);
				select_clear();
			}
			m_undo_buffer.push(info);
		}

		mi.modified_line          = m_pos.xy.y;
		mi.is_modified_linecount |= (buffer.size() > 1);

		_Insert(buffer);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// ݈ʒuɉs}
bool edit_manager::insert_linefeed(modify_info &mi)
{
	if(is_readonly()) { return false; }

	try
	{
		iterator_t p = m_pos.it;

		// ff
		assert(static_cast<size_t>(m_pos.xy.x) <= p->length());

		// s2܂ރobt@쐬
		linelist_t buffer;
		buffer.push_back(edit_line());
		buffer.push_back(edit_line());

		// {block}
		// AhDobt@֒ǉ
		{
			undo_info info;
			info.move_cursor = true;
			info.position    = m_pos.xy;
			info.text_append = buffer;

			// IĂΑI͈͂폜
			if(is_selected())
			{
				pos_t begin, end;
				_SelectGetRange(begin, end);
				_RangeDelete(begin, end, info, mi);
				select_clear();
			}
			m_undo_buffer.push(info);
		}

		mi.modified_line         = m_pos.xy.y;
		mi.is_modified_linecount = true;

		// obt@̓e}
		_Insert(buffer);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// 𑗐Mi}㏑fj
bool edit_manager::send_string(const wchar_t *wstr, const size_t length, modify_info &mi)
{
	if(is_readonly()) { return false; }
	if(length == 0  ) { return false; }

	// ff
	assert(static_cast<size_t>(m_pos.xy.x) <= m_pos.it->length());

	try
	{
		undo_info info;
		info.move_cursor = true;
		info.position    = m_pos.xy;
		info.text_append.assign(1, edit_line(wstr));

		mi.modified_line         = m_pos.xy.y;
		mi.is_modified_linecount = false;

		// IĂΑI͈͂폜
		if(is_selected())
		{
			pos_t begin, end;
			_SelectGetRange(begin, end);
			_RangeDelete(begin, end, info, mi);
			select_clear();
		}

		// ㏑
		if(is_overwrite())
		{
			wstring_t str_delete;
			m_pos.it->overwrite(m_pos.xy.x, wstr, length, &str_delete);
			info.text_delete.assign(1, edit_line(str_delete));
		}
		// }
		else
		{
			m_pos.it->insert(m_pos.xy.x, wstr, length);
		}

		// AhDobt@֒ǉ
		m_undo_buffer.push(info);

		shift_x(length);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// ݈ʒu̕폜
bool edit_manager::delete_char(const bool left, modify_info &mi)
{
	if(is_readonly()) { return false; }

	try
	{
		undo_info info;

		// IĂΑI͈͂폜
		if(is_selected())
		{
			info.move_cursor = left;

			pos_t begin, end;
			_SelectGetRange(begin, end);
			_RangeDelete(begin, end, info, mi);
			select_clear();
		}
		else
		{
			// ̕폜iBackSpacej
			if(left)
			{
				info.move_cursor = true;

				// s̏ꍇ
				if(m_pos.xy.x == 0)
				{
					// obt@̐擪ȂI
					if(m_pos.xy.y == 0) { return false; }

					// {block}
					// 폜i[
					{
						iterator_t pos = m_pos.it;
						pos--;
						info.text_delete.push_back(edit_line(pos->lf_type()));
						info.text_delete.push_back(edit_line());
					}

					// O̍sƘA
					_Combine(false, mi);
					goto push_undo;
				}
				shift_x(-1);
			}
			// E̕폜iDeletej
			else
			{
				info.move_cursor = false;

				// s̏ꍇ
				const intptr_t length = m_pos.it->length();
				if(m_pos.xy.x == length)
				{
					// obt@̖ȂI
					const intptr_t size = m_list.size() - 1;
					if(m_pos.xy.y == size) { return false; }

					// {block}
					// 폜i[
					{
						iterator_t pos = m_pos.it;
						info.text_delete.push_back(edit_line(pos->lf_type()));
						info.text_delete.push_back(edit_line());
					}

					// ̍sƘA
					_Combine(true, mi);
					goto push_undo;
				}
			}

			// {block}
			// 폜
			{
				wstring_t deleted_string;
				m_pos.it->erase(m_pos.xy.x, 1, &deleted_string);
				info.text_delete.assign(1, edit_line(deleted_string));

				mi.modified_line         = m_pos.xy.y;
				mi.is_modified_linecount = false;
			}
		}

push_undo:
		// AhDobt@֒ǉ
		info.position = m_pos.xy;
		m_undo_buffer.push(info);

		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// ݍs폜
bool edit_manager::delete_line(modify_info &mi)
{
	if(is_readonly()) { return false; }

	// I͈͂IɃNA
	select_clear();

	mi.is_modified_linecount = true;
	mi.modified_line         = m_pos.xy.y;

	undo_info info;

	// ŏIsȂsɂ邾isԍ̕ύX͂Ȃj
	if(is_end())
	{
		if(m_pos.it->length() == 0)
		{
			return false;
		}
		info.text_delete.assign(1, *m_pos.it);

		m_pos.it->erase(0);
		m_pos.xy.x = 0;
		mi.is_modified_linecount = false;
	}
	else
	{
		// ŏIsłȂΌݍs폜
		linelist_t::iterator p = m_pos.it++;
		info.text_delete.assign(1, *p);
		info.text_delete.push_back(edit_line());

		m_list.erase(p);
		m_pos.xy.x = 0;
	}

	info.move_cursor = false;
	info.position    = m_pos.xy;
	m_undo_buffer.push(info);
	return true;
}


////////////////////////////////////////////////////////////////
// I

// ݈ʒu̒PI
void edit_manager::select_word(const select_cursor_t cursor_pos /* = SC_NOMOVE */, const bool update_selection /* = false */)
{
	// ݈ʒuɁAJeSɑ镶݂̂I
	const wchar_t *line   = m_pos.it->c_str();
	const size_t   length = m_pos.it->length();
	const size_t x = m_pos.xy.x;

	bool end_forward = true;
	if(!update_selection)
	{
		m_select.begin = m_pos;
		m_select.begin.xy.x = _FindWordBreak(line, length, x, false);
	}
	else
	{
		end_forward = (m_pos.xy > m_select.begin.xy);
	}
	m_select.end = m_pos;
	m_select.end.xy.x = _FindWordBreak(line, length, x, end_forward);

	// J[\ʒu
	switch(cursor_pos)
	{
	case SC_BEGIN:
		m_pos.xy.x = m_select.begin.xy.x;
		break;

	case SC_END:
		m_pos.xy.x = m_select.end.xy.x;
		break;
	}
}

// ݍsI
void edit_manager::select_line(const select_cursor_t cursor_pos /* = SC_NOMOVE */, const bool update_selection /* = false */)
{
	// Jnʒu̐ݒ
	if(!update_selection)
	{
		m_select.begin = m_pos;
		m_select.begin.xy.x = 0;
	}

	// Iʒu̐ݒ
	m_select.end = m_pos;
	if(!update_selection || m_select.end.xy > m_select.begin.xy)
	{
		if(is_end())
		{
			// ݍsobt@̏I[ȂIʒu݈ʒu̖
			m_select.end.xy.x = m_pos.it->length();
		}
		else
		{
			// I[łȂΏIʒu̍s̐擪
			m_select.end.it++;
			m_select.end.xy.x = 0;
			m_select.end.xy.y++;
		}
	}
	else
	{
		m_select.end.xy.x = 0;
	}

	// J[\ʒu
	switch(cursor_pos)
	{
	case SC_BEGIN:
		m_pos = m_select.begin;
		break;

	case SC_END:
		m_pos = m_select.end;
		break;
	}
}

// SđI
void edit_manager::select_all(void)
{
	// {block}
	{
		m_select.begin.it = m_list.begin();
		m_select.begin.xy.x = 0;
		m_select.begin.xy.y = 0;
	}
	// {block}
	{
		m_select.end.it = m_list.end(); m_select.end.it--;
		m_select.end.xy.x = m_select.end.it->length();
		m_select.end.xy.y = m_list.size() - 1;
	}
}

// I
void edit_manager::select_clear(const select_cursor_t cursor_pos /* = SC_NOMOVE */)
{
	if(!is_selected()) { return; }

	// J[\ʒuݒ
	if(cursor_pos != SC_NOMOVE)
	{
		pos_t begin, end;
		_SelectGetRange(begin, end);

		switch(cursor_pos)
		{
		case SC_BEGIN:
			m_pos = begin;
			break;

		case SC_END:
			m_pos = end;
			break;
		}
	}
	m_select.begin = m_select.end = m_pos;
}

// I͈͂XV
void edit_manager::select_update(const bool clear /* = false */)
{
	m_select.end = m_pos;

	// I͈͂NA
	if(clear)
	{
		m_select.begin = m_select.end;
	}
}

// I͈͂폜
bool edit_manager::select_delete(modify_info &mi)
{
	if( is_readonly()) { return false; }
	if(!is_selected()) { return false; }

	pos_t begin, end;
	_SelectGetRange(begin, end);

	// ͈͂폜
	undo_info info;
	_RangeDelete(begin, end, info, mi);
	select_clear();

	m_undo_buffer.push(info);

	return true;
}

// I͈͂̕擾
void edit_manager::select_get_string(wstring_t &wstr) const
{
	if(!is_selected()) { return; }

	pos_t begin, end;
	_SelectGetRange(begin, end);

	// 1sIĂȂꍇ
	if(begin.xy.y == end.xy.y)
	{
		wstr = begin.it->substr(begin.xy.x, end.xy.x - begin.xy.x);
	}
	// sIĂꍇ
	else
	{
		// 1s
		const_iterator_t p = begin.it;
		wstr  = p->substr(begin.xy.x);
		wstr += charcode::get_linefeed_string(p->lf_type());

		// 2sځ`ŏIs-1s
		while(++p != end.it)
		{
			wstr += p->c_str();
			wstr += charcode::get_linefeed_string(p->lf_type());
		}

		// ŏIs
		if(p != m_list.end())
		{
			wstr += p->substr(0, end.xy.x);
		}
	}
}

// IJnEIʒu擾
void edit_manager::select_get_range(position_t &sel_begin, position_t &sel_end) const
{
	pos_t begin, end;
	_SelectGetRange(begin, end);
	sel_begin = begin.xy;
	sel_end   = end.xy;
}

// IĂ邩H
bool edit_manager::is_selected(void) const
{
	// JnʒuIʒuȂFALSE
	if(m_select.begin.xy.x == m_select.end.xy.x && m_select.begin.xy.y == m_select.end.xy.y)
	{
		return false;
	}
	// ȊOȂTRUE
	return true;
}


////////////////////////////////////////////////////////////////////////////////
// protected֐

// ݍsƎorO̍sA
bool edit_manager::_Combine(const bool forward, modify_info &mi)
{
	iterator_t p = m_pos.it;                     // Ai폜鑤j

	// ̍sA
	if(forward)
	{
		if(is_end()) { return false; }

		// A̍s
		p++;
	}
	// O̍sA
	else
	{
		if(is_begin()) { return false; }

		// A恁O̍s
		shift_y(-1);
	}

	mi.modified_line         = m_pos.xy.y;
	mi.is_modified_linecount = true;

	set_x(m_pos.it->length());

	// A
	*(m_pos.it) += *p;
	m_list.erase(p);

	return true;
}


// pos폜
void edit_manager::_Delete(iterator_t &pos, const size_t count /* = 1 */, const bool forward /* = true */)
{
	iterator_t begin = pos;
	iterator_t end   = pos;

	// O폜
	if(forward)
	{
		for(size_t i = 0; i < count; i++)
		{
			if(end == m_list.end())
			{
				break;
			}
			end++;
		}
	}
	// 폜
	else
	{
		for(size_t i = 0; i < count; i++)
		{
			if(begin == m_list.begin())
			{
				break;
			}
			begin--;
		}
	}

	// pos͍폜s̎w
	pos = m_list.erase(begin, end);
}

// ݈ʒuobt@e폜iundo() / redo() Ŏgpj
void edit_manager::_DeleteLineList(const linelist_t &buffer)
{
	if(buffer.empty()) { return; }

	const size_t delete_lines = buffer.size();

	// Eij폜
	if(delete_lines >= 2)
	{
		iterator_t pos = m_pos.it;
		pos++;
		_Delete(pos, delete_lines - 2);

		const edit_line rear  = pos->substr(buffer.back().length()); pos--;
		const edit_line front = pos->substr(0, pos->length() - buffer.front().length());
		_Delete(pos, 2);

		m_pos.it = m_list.insert(pos, front + rear);
	}
	else
	{
		const size_t length = buffer.front().length();
		m_pos.it->erase(m_pos.xy.x, length);
	}
}

// ݈ʒubuffer}
void edit_manager::_Insert(linelist_t &buffer, const bool move_buffer /* = true */, const bool move_cursor /* = true */)
{
	if(buffer.empty()) { return; }

	const size_t lines  = buffer.size();
	const size_t length = buffer.back().length();

	// {block}
	// obt@̓e}
	{
		// splice() p̃obt@쐬
		linelist_t buffer_tmp;
		if(move_buffer)
		{
			buffer_tmp.splice(buffer_tmp.end(), buffer);
		}
		else
		{
			buffer_tmp = buffer;
		}

		// {block}
		// ݈ʒu̕obt@̑Oɒǉ
		{
			// ݈ʒu̕𕪊
			edit_line front, rear;
			m_pos.it->split(m_pos.xy.x, front, rear);

			// O̕ǉ
			buffer_tmp.front() = front + buffer_tmp.front();
			buffer_tmp.back () = buffer_tmp.back() + rear;
		}

		// {block}
		// }
		{
			iterator_t p = m_pos.it;
			m_list.splice(++p, buffer_tmp);
		}
	}

	// {block}
	// ݈ʒu폜
	{
		// 폜OɌ݈ʒũCe[^1i߂
		iterator_t p = m_pos.it++;
		_Delete(p);
	}

	// ʒuXV
	if(move_cursor)
	{
		size_t x = length;
		if(lines == 1) { x += m_pos.xy.x; }

		shift_y(lines - 1);
		set_x(x);
	}
}


// P̋E
size_t edit_manager::_FindWordBreak(const wchar_t *line, const size_t length, const size_t pos, const bool forward /* = true */) const
{
	size_t idx = pos;

	// 擪
	if(forward)
	{
		if(pos >= length) { return pos; }
		const charcode::categorize_t category = charcode::categorize(line[pos]);
		while(idx < length)
		{
			if(charcode::categorize(line[idx]) != category) { break; }
			idx++;
		}
	}
	else
	{
		if(pos == 0) { return pos; }
		const charcode::categorize_t category = charcode::categorize(line[pos - 1]);
		while(idx > 0)
		{
			if(charcode::categorize(line[idx - 1]) != category) { break; }
			idx--;
		}
	}
	return idx;
}

// I͈͂擾
void edit_manager::_SelectGetRange(pos_t &pos_begin, pos_t &pos_end) const
{
	pos_begin = m_select.begin;
	pos_end   = m_select.end;

	if(pos_begin.xy > pos_end.xy)
	{
		std::swap(pos_begin, pos_end);
	}
}

// w͈͂̍sXg쐬
void edit_manager::_RangeCreateLineList(const pos_t &begin, const pos_t &end, linelist_t &linelist) const
{
	// 1sIĂȂꍇ
	if(begin.xy.y == end.xy.y)
	{
		const size_t offset = begin.xy.x;
		const size_t count  = end.xy.x - begin.xy.x;
		linelist.push_back(edit_line(begin.it->substr(offset, count)));
	}
	// sIĂꍇ
	else
	{
		iterator_t it_next = begin.it; it_next++;

		linelist.push_back(edit_line(begin.it->substr(begin.xy.x), begin.it->lf_type()));
		for(iterator_t p = it_next; p != end.it; p++)
		{
			linelist.push_back(*p);
		}
		linelist.push_back(edit_line(end.it->substr(0, end.xy.x)));
	}
}

void edit_manager::_RangeDelete(const pos_t &begin, const pos_t &end, undo_info &info, modify_info &mi)
{
	// ݈ʒu͈͂̐擪
	m_pos = begin;

	// sXg쐬
	info.position = begin.xy;
	_RangeCreateLineList(begin, end, info.text_delete);

	// 1sw肳ĂȂꍇ
	if(begin.xy.y == end.xy.y)
	{
		const size_t offset = begin.xy.x;
		const size_t count  = end.xy.x - begin.xy.x;

		begin.it->erase(offset, count);
	}
	// sw肳Ăꍇ
	else
	{
		iterator_t it_next = begin.it; it_next++;

		// 2sځ`ŏIs-1sڂ폜
		m_list.erase(it_next, end.it);

		begin.it->erase(begin.xy.x);            // 1sڂ̑Iʒuȍ~폜
		end  .it->erase(0         , end.xy.x);  // ŏIs̑Iʒu܂ł폜

		_Combine(true, mi);
	}

	mi.modified_line = begin.xy.y;
	mi.is_modified_linecount = (info.text_delete.size() > 1);
}


// poscountsXN[
intptr_t edit_manager::_Scroll(const intptr_t count, const_iterator_t &pos) const
{
	if(count > 0)
	{
		return _ScrollForward(count, pos);
	}
	else
	{
		return -_ScrollBackward(-count, pos);
	}
}

// ɃXN[
intptr_t edit_manager::_ScrollForward(const size_t count, const_iterator_t &pos) const
{
	// ݈ʒuXV
	for(size_t i = 0; i < count; i++)
	{
		const_iterator_t p = pos;
		if(++p == get_iterator_end())
		{
			return i;
		}
		pos++;
	}

	// ۂɃXN[sԂ
	return count;
}

// 擪ɃXN[
intptr_t edit_manager::_ScrollBackward(const size_t count, const_iterator_t &pos) const
{
	// ݈ʒuXV
	for(size_t i = 0; i < count; i++)
	{
		if(get_iterator_begin() == pos)
		{
			return i;
		}
		pos--;
	}

	// ۂɃXN[sԂ
	return count;
}


// wsԍ̃Ce[^擾ilinenumber==0 Ȃ疖Alinenumber==1 Ȃ擪j
edit_manager::linenumber_t edit_manager::_GetPosition(const linenumber_t linenumber, const_iterator_t &pos) const
{
	const size_t        line_count = get_line_count();
	const iterator_t   &base_iterator   = m_pos.it;   // ʒu݈ʒu
	const linenumber_t &base_linenumber = m_pos.xy.y + 1;

	// 擪
	if(linenumber == 1)
	{
		pos = get_iterator_begin();
		return 1;
	}
	// 
	if(linenumber == 0 || linenumber >= line_count)
	{
		pos = get_iterator_end();
		pos--;
		return line_count;
	}

	// ʒu擪
	if(linenumber < base_linenumber)
	{
		const linenumber_t diff = base_linenumber - linenumber;

		// 擪ɋ߂
		if(linenumber < diff)
		{
			// 擪猟
			pos = get_iterator_begin();
			_ScrollForward(linenumber - 1, pos);
			return linenumber;
		}
		// ʒuɋ߂
		else
		{
			// ʒu猟
			pos = base_iterator;
			_ScrollBackward(diff, pos);
			return linenumber;
		}
	}
	// ʒu薖
	if(linenumber > base_linenumber)
	{
		const linenumber_t diff = linenumber - base_linenumber;

		// ɋ߂
		if(line_count - linenumber < diff)
		{
			// 猟
			pos = get_iterator_end();
			pos--;
			_ScrollBackward(line_count - linenumber, pos);
			return linenumber;
		}
		// ʒuɋ߂
		else
		{
			// ʒu猟
			pos = base_iterator;
			_ScrollForward(diff, pos);
			return linenumber;
		}
	}

	// ʒu
	pos = base_iterator;
	return linenumber;
}


// s̃eLXgAsȂ̕񃊃Xg쐬
void edit_manager::_CreateLineList(const wchar_t *text, const size_t size, linelist_t &linelist)
{
	size_t size2 = size;
	for(;;)
	{
		// sʒu
		charcode::linefeed_t lf_type;
		size_t skip;

		const size_t pos = charcode::find_linefeed(text, size2, lf_type, skip);
		if(pos == charcode::POS_INVALID)
		{
			// ŏIs
			linelist.push_back(edit_line(text, size2));
			break;
		}

		// ؂o
		linelist.push_back(edit_line(text, pos, lf_type));

		// {block}
		// ̈ʒuvZ
		{
			const size_t offset = pos + skip;
			text  += offset;
			size2 -= offset;
		}
	}
}

_SGC_END                                // }
